/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.schedulers.cloudlet.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.cloudlets.network.CloudletExecutionTask;
import org.cloudsimplus.cloudlets.network.CloudletReceiveTask;
import org.cloudsimplus.cloudlets.network.CloudletSendTask;
import org.cloudsimplus.cloudlets.network.CloudletTask;
import org.cloudsimplus.cloudlets.network.NetworkCloudlet;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.network.VmPacket;
import org.cloudsimplus.schedulers.cloudlet.network.CloudletTaskScheduler;
import org.cloudsimplus.vms.Vm;
import org.cloudsimplus.vms.network.NetworkVm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudletTaskSchedulerSimple
implements CloudletTaskScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CloudletTaskSchedulerSimple.class.getSimpleName());
    private Vm vm;
    private final List<VmPacket> vmPacketsToSend = new ArrayList<VmPacket>();
    private final Map<Vm, List<VmPacket>> vmPacketsReceivedMap = new HashMap<Vm, List<VmPacket>>();

    @Override
    public void processCloudletTasks(Cloudlet cloudlet, long partialFinishedMI) {
        if (cloudlet.isRunning() && cloudlet instanceof NetworkCloudlet) {
            NetworkCloudlet netCloudlet = (NetworkCloudlet)cloudlet;
            if (!netCloudlet.isTasksStarted()) {
                this.scheduleNextTaskIfCurrentIsFinished(netCloudlet);
                return;
            }
            if (this.isTimeToUpdateCloudletProcessing(netCloudlet)) {
                this.updateExecutionTask(netCloudlet, partialFinishedMI);
            } else {
                this.updateNetworkTasks(netCloudlet);
            }
        }
    }

    private void updateExecutionTask(NetworkCloudlet cloudlet, long partialFinishedMI) {
        Optional<CloudletExecutionTask> optional = this.getCloudletCurrentTask(cloudlet);
        optional.ifPresent(task -> {
            task.process(partialFinishedMI);
            this.scheduleNextTaskIfCurrentIsFinished(cloudlet);
        });
    }

    private void updateNetworkTasks(NetworkCloudlet cloudlet) {
        cloudlet.getCurrentTask().ifPresent(task -> {
            if (task instanceof CloudletSendTask) {
                CloudletSendTask sendTask = (CloudletSendTask)task;
                this.addPacketsToBeSentFromVm(cloudlet, sendTask);
            } else if (task instanceof CloudletReceiveTask) {
                CloudletReceiveTask receiveTask = (CloudletReceiveTask)task;
                this.receivePackets(cloudlet, receiveTask);
            }
        });
    }

    @Override
    public boolean isTimeToUpdateCloudletProcessing(@NonNull Cloudlet cloudlet) {
        if (cloudlet == null) {
            throw new NullPointerException("cloudlet is marked non-null but is null");
        }
        if (cloudlet.isFinished()) {
            return false;
        }
        if (cloudlet instanceof NetworkCloudlet) {
            NetworkCloudlet nc = (NetworkCloudlet)cloudlet;
            return nc.getCurrentTask().filter(CloudletTask::isExecutionTask).isPresent();
        }
        return true;
    }

    private void addPacketsToBeSentFromVm(NetworkCloudlet sourceCloudlet, CloudletSendTask task) {
        LOGGER.trace("{}: {}: {} pkts added to be sent from {} in {}", new Object[]{sourceCloudlet.getSimulation().clockStr(), this.getClass().getSimpleName(), task.getPacketsToSend().size(), sourceCloudlet, sourceCloudlet.getVm()});
        this.vmPacketsToSend.addAll(task.getPacketsToSend(sourceCloudlet.getSimulation().clock()));
        this.scheduleNextTaskIfCurrentIsFinished(sourceCloudlet);
    }

    private void receivePackets(NetworkCloudlet destinationCloudlet, CloudletReceiveTask task) {
        List<VmPacket> receivedPkts = this.getPacketsSentToCloudlet(task);
        receivedPkts.forEach(task::receivePacket);
        receivedPkts.forEach(pkt -> this.logReceivedPacket(destinationCloudlet, (VmPacket)pkt));
        this.getListOfPacketsSentFromVm(task.getSourceVm()).removeAll(receivedPkts);
        this.scheduleNextTaskIfCurrentIsFinished(destinationCloudlet);
    }

    private void logReceivedPacket(NetworkCloudlet destinationCloudlet, VmPacket pkt) {
        LOGGER.trace("{}: {}: {} in {} received pkt with {} bytes from {} in {}", new Object[]{destinationCloudlet.getSimulation().clockStr(), this.getClass().getSimpleName(), pkt.getReceiverCloudlet(), pkt.getDestination(), pkt.getSize(), pkt.getSenderCloudlet(), pkt.getSource()});
    }

    private <T extends CloudletTask> Optional<T> getCloudletCurrentTask(NetworkCloudlet cloudlet) {
        return cloudlet.getCurrentTask().map(task -> task);
    }

    private List<VmPacket> getPacketsSentToCloudlet(CloudletReceiveTask receiveTask) {
        List<VmPacket> pktsFromExpectedSenderVm = this.getListOfPacketsSentFromVm(receiveTask.getSourceVm());
        return pktsFromExpectedSenderVm.stream().filter(pkt -> pkt.getDestination().equals(receiveTask.getCloudlet().getVm())).filter(pkt -> pkt.getReceiverCloudlet().equals(receiveTask.getCloudlet())).collect(Collectors.toList());
    }

    private void scheduleNextTaskIfCurrentIsFinished(NetworkCloudlet cloudlet) {
        if (!cloudlet.startNextTaskIfCurrentIsFinished(cloudlet.getSimulation().clock())) {
            return;
        }
        Datacenter dc = this.getVm().getHost().getDatacenter();
        dc.schedule(dc, dc.getSimulation().getMinTimeBetweenEvents(), CloudSimTag.VM_UPDATE_CLOUDLET_PROCESSING);
    }

    @Override
    public void clearVmPacketsToSend() {
        this.vmPacketsToSend.clear();
    }

    @Override
    public List<VmPacket> getVmPacketsToSend() {
        return Collections.unmodifiableList(this.vmPacketsToSend);
    }

    private List<VmPacket> getListOfPacketsSentFromVm(Vm sourceVm) {
        return this.vmPacketsReceivedMap.getOrDefault(sourceVm, new ArrayList());
    }

    @Override
    public boolean addPacketToListOfPacketsSentFromVm(VmPacket pkt) {
        NetworkVm vm = pkt.getSource();
        return this.vmPacketsReceivedMap.compute(vm, (k, v) -> v == null ? new ArrayList() : v).add(pkt);
    }

    @Override
    public final Vm getVm() {
        return this.vm;
    }

    @Override
    public final CloudletTaskSchedulerSimple setVm(Vm vm) {
        this.vm = vm;
        return this;
    }
}

