/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.schedulers.cloudlet;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.cloudsimplus.cloudlets.CloudletExecution;
import org.cloudsimplus.schedulers.MipsShare;
import org.cloudsimplus.schedulers.cloudlet.CloudletSchedulerTimeShared;
import org.cloudsimplus.util.MathUtil;

public final class CloudletSchedulerCompletelyFair
extends CloudletSchedulerTimeShared {
    private static final long serialVersionUID = 9077807080812191007L;
    private int minimumGranularity = 2;
    private int latency = 3;

    public void setLatency(int latency) {
        if (latency < this.minimumGranularity) {
            throw new IllegalArgumentException("Latency cannot be lower than the mininum granularity.");
        }
        this.latency = latency;
    }

    private int waitingCloudletsComparator(CloudletExecution c1, CloudletExecution c2) {
        double vRuntimeDiff = c1.getVirtualRuntime() - c2.getVirtualRuntime();
        if (vRuntimeDiff != 0.0) {
            return MathUtil.doubleToInt(vRuntimeDiff);
        }
        long priorityDiff = c1.getCloudlet().getPriority() - c2.getCloudlet().getPriority();
        long idDiff = c1.getCloudletId() - c2.getCloudletId();
        return Math.round(priorityDiff == 0L ? (float)idDiff : (float)priorityDiff);
    }

    private double computeCloudletTimeSlice(CloudletExecution cloudlet) {
        double timeSlice = (double)this.getLatency() * this.getCloudletWeightPercentBetweenAllCloudlets(cloudlet);
        return Math.min(timeSlice, (double)this.minimumGranularity);
    }

    @Override
    public List<CloudletExecution> getCloudletWaitingList() {
        return super.getCloudletWaitingList();
    }

    @Override
    protected Optional<CloudletExecution> findSuitableWaitingCloudlet() {
        this.sortCloudletWaitingList(this::waitingCloudletsComparator);
        return super.findSuitableWaitingCloudlet();
    }

    private double getCloudletWeight(CloudletExecution cloudlet) {
        return 1024.0 / Math.pow(1.25, this.getCloudletNiceness(cloudlet));
    }

    private double getCloudletNiceness(CloudletExecution cloudlet) {
        return -cloudlet.getCloudlet().getPriority();
    }

    private double getCloudletWeightPercentBetweenAllCloudlets(CloudletExecution cloudlet) {
        return this.getCloudletWeight(cloudlet) / this.getWeightSumOfRunningCloudlets();
    }

    private double getWeightSumOfRunningCloudlets() {
        return this.getCloudletExecList().stream().mapToDouble(this::getCloudletWeight).sum();
    }

    public void setMinimumGranularity(int minimumGranularity) {
        if (minimumGranularity > this.latency) {
            throw new IllegalArgumentException("Minimum granularity cannot be greater than latency.");
        }
        this.minimumGranularity = minimumGranularity;
    }

    @Override
    protected double cloudletSubmitInternal(CloudletExecution cle, double fileTransferTime) {
        cle.setVirtualRuntime(this.computeCloudletInitialVirtualRuntime(cle));
        cle.setTimeSlice(this.computeCloudletTimeSlice(cle));
        return super.cloudletSubmitInternal(cle, fileTransferTime);
    }

    @Override
    public double updateProcessing(double currentTime, MipsShare mipsShare) {
        super.updateProcessing(currentTime, mipsShare);
        return this.getCloudletExecList().stream().mapToDouble(CloudletExecution::getTimeSlice).min().orElse(Double.MAX_VALUE);
    }

    @Override
    public long updateCloudletProcessing(CloudletExecution cle, double currentTime) {
        if (cle.getVirtualRuntime() < 0.0) {
            cle.setVirtualRuntime(0.0);
        }
        double cloudletTimeSpan = currentTime - cle.getLastProcessingTime();
        long partialFinishedMI = super.updateCloudletProcessing(cle, currentTime);
        cle.addVirtualRuntime(cloudletTimeSpan);
        return partialFinishedMI;
    }

    private double computeCloudletInitialVirtualRuntime(CloudletExecution cloudlet) {
        double inverseCloudletId = 2.147483647E9 / ((double)cloudlet.getCloudletId() + 1.0);
        return -Math.abs((double)cloudlet.getCloudlet().getPriority() + inverseCloudletId);
    }

    @Override
    protected boolean canExecuteCloudletInternal(CloudletExecution cloudlet) {
        return this.isThereEnoughFreePesForCloudlet(cloudlet);
    }

    @Override
    public List<CloudletExecution> getCloudletExecList() {
        return super.getCloudletExecList();
    }

    @Override
    protected double moveNextCloudletsFromWaitingToExecList(double currentTime) {
        List<CloudletExecution> preemptedCloudlets = this.preemptExecCloudletsWithExpiredVRuntimeAndMoveToWaitingList();
        double nextCloudletFinishTime = super.moveNextCloudletsFromWaitingToExecList(currentTime);
        for (CloudletExecution c : preemptedCloudlets) {
            c.setVirtualRuntime(this.computeCloudletInitialVirtualRuntime(c));
        }
        return nextCloudletFinishTime;
    }

    private List<CloudletExecution> preemptExecCloudletsWithExpiredVRuntimeAndMoveToWaitingList() {
        Predicate<CloudletExecution> vrtReachedTimeSlice = cle -> cle.getVirtualRuntime() >= cle.getTimeSlice();
        List<CloudletExecution> expiredVrtCloudlets = this.getCloudletExecList().stream().filter(vrtReachedTimeSlice).toList();
        expiredVrtCloudlets.forEach(cle -> this.addCloudletToWaitingList(this.removeCloudletFromExecList((CloudletExecution)cle)));
        return expiredVrtCloudlets;
    }

    public final int getMinimumGranularity() {
        return this.minimumGranularity;
    }

    public final int getLatency() {
        return this.latency;
    }
}

