/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.schedulers.cloudlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.cloudlets.CloudletExecution;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.listeners.CloudletResourceAllocationFailEventInfo;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.resources.FileStorage;
import org.cloudsimplus.resources.Ram;
import org.cloudsimplus.resources.ResourceManageable;
import org.cloudsimplus.schedulers.MipsShare;
import org.cloudsimplus.schedulers.cloudlet.CloudletScheduler;
import org.cloudsimplus.schedulers.cloudlet.network.CloudletTaskScheduler;
import org.cloudsimplus.utilizationmodels.UtilizationModel;
import org.cloudsimplus.vms.Vm;
import org.cloudsimplus.vms.VmSimple;

public abstract class CloudletSchedulerAbstract
implements CloudletScheduler {
    private static final long serialVersionUID = -2314361120790372742L;
    private Vm vm;
    private CloudletTaskScheduler taskScheduler;
    private MipsShare currentMipsShare;
    private double previousTime;
    private final List<CloudletExecution> cloudletFinishedList;
    private final List<CloudletExecution> cloudletPausedList;
    private final List<CloudletExecution> cloudletFailedList;
    private final List<CloudletExecution> cloudletExecList;
    private final List<CloudletExecution> cloudletWaitingList;
    private final Set<Cloudlet> cloudletReturnedList;
    private final List<Cloudlet> cloudletSubmittedList;
    private boolean cloudletSubmittedListEnabled;
    private final List<EventListener<CloudletResourceAllocationFailEventInfo>> resourceAllocationFailListeners;

    protected CloudletSchedulerAbstract() {
        this.setPreviousTime(0.0);
        this.vm = Vm.NULL;
        this.cloudletSubmittedList = new ArrayList<Cloudlet>();
        this.cloudletExecList = new ArrayList<CloudletExecution>();
        this.cloudletPausedList = new ArrayList<CloudletExecution>();
        this.cloudletFinishedList = new ArrayList<CloudletExecution>();
        this.cloudletFailedList = new ArrayList<CloudletExecution>();
        this.cloudletWaitingList = new ArrayList<CloudletExecution>();
        this.cloudletReturnedList = new HashSet<Cloudlet>();
        this.currentMipsShare = new MipsShare();
        this.taskScheduler = CloudletTaskScheduler.NULL;
        this.resourceAllocationFailListeners = new ArrayList<EventListener<CloudletResourceAllocationFailEventInfo>>();
    }

    protected final void setPreviousTime(double previousTime) {
        this.previousTime = previousTime;
    }

    protected void setCurrentMipsShare(@NonNull MipsShare currentMipsShare) {
        if (currentMipsShare == null) {
            throw new NullPointerException("currentMipsShare is marked non-null but is null");
        }
        if (currentMipsShare.pes() > this.vm.getPesNumber()) {
            LOGGER.warn("Requested {} PEs but {} has just {}", new Object[]{currentMipsShare.pes(), this.vm, this.vm.getPesNumber()});
            this.currentMipsShare = new MipsShare(this.vm.getPesNumber(), currentMipsShare.mips());
        } else {
            this.currentMipsShare = currentMipsShare;
        }
    }

    public double getAvailableMipsByPe() {
        long totalAllExecCloudletsPes = this.totalAllExecCloudletsPes();
        if (totalAllExecCloudletsPes > this.currentMipsShare.pes()) {
            return this.getTotalMipsShare() / (double)totalAllExecCloudletsPes;
        }
        return this.getPeCapacity();
    }

    private Double getPeCapacity() {
        return this.currentMipsShare.mips();
    }

    private long totalAllExecCloudletsPes() {
        return this.cloudletExecList.stream().map(CloudletExecution::getCloudlet).mapToLong(Cloudlet::getPesNumber).sum();
    }

    private double getTotalMipsShare() {
        return this.currentMipsShare.totalMips();
    }

    @Override
    public List<CloudletExecution> getCloudletExecList() {
        return Collections.unmodifiableList(this.cloudletExecList);
    }

    @Override
    public <T extends Cloudlet> List<T> getCloudletSubmittedList() {
        if (this.cloudletSubmittedList.isEmpty() && !this.cloudletSubmittedListEnabled) {
            LOGGER.warn("{}: The list of submitted Cloudlets for {} is empty maybe because you didn't enabled it by calling enableCloudletSubmittedList().", (Object)this.getClass().getSimpleName(), (Object)this.vm);
        }
        return this.cloudletSubmittedList;
    }

    @Override
    public CloudletScheduler enableCloudletSubmittedList() {
        this.cloudletSubmittedListEnabled = true;
        return this;
    }

    protected void addCloudletToWaitingList(CloudletExecution cle) {
        if (Objects.requireNonNull(cle) == CloudletExecution.NULL) {
            return;
        }
        if (cle.getCloudlet().getStatus() != Cloudlet.Status.FROZEN) {
            cle.setStatus(Cloudlet.Status.QUEUED);
        }
        this.cloudletWaitingList.add(cle);
    }

    @Override
    public List<CloudletExecution> getCloudletWaitingList() {
        return Collections.unmodifiableList(this.cloudletWaitingList);
    }

    protected void sortCloudletWaitingList(Comparator<CloudletExecution> comparator) {
        this.cloudletWaitingList.sort(comparator);
    }

    @Override
    public final double cloudletSubmit(Cloudlet cloudlet) {
        return this.cloudletSubmit(cloudlet, 0.0);
    }

    @Override
    public final double cloudletSubmit(Cloudlet cloudlet, double fileTransferTime) {
        if (this.cloudletSubmittedListEnabled) {
            this.cloudletSubmittedList.add(cloudlet);
        }
        return this.cloudletSubmitInternal(new CloudletExecution(cloudlet), fileTransferTime);
    }

    protected double cloudletSubmitInternal(CloudletExecution cle, double fileTransferTime) {
        if (this.canExecuteCloudlet(cle)) {
            cle.setStatus(Cloudlet.Status.INEXEC);
            cle.setFileTransferTime(fileTransferTime);
            this.addCloudletToExecList(cle);
            return fileTransferTime + Math.abs((double)cle.getCloudletLength() / this.getPeCapacity());
        }
        this.addCloudletToWaitingList(cle);
        return 0.0;
    }

    protected void addCloudletToExecList(CloudletExecution cle) {
        cle.setStatus(Cloudlet.Status.INEXEC);
        cle.setLastProcessingTime(this.getVm().getSimulation().clock());
        this.cloudletExecList.add(cle);
        this.addUsedPes(cle.getPesNumber());
    }

    @Override
    public boolean hasFinishedCloudlets() {
        return !this.cloudletFinishedList.isEmpty();
    }

    protected Optional<CloudletExecution> findCloudletInAllLists(double cloudletId) {
        Stream<List> cloudletExecInfoListStream = Stream.of(this.cloudletExecList, this.cloudletPausedList, this.cloudletWaitingList, this.cloudletFinishedList, this.cloudletFailedList);
        return cloudletExecInfoListStream.flatMap(Collection::stream).filter(cle -> (double)cle.getCloudletId() == cloudletId).findFirst();
    }

    protected Optional<CloudletExecution> findCloudletInList(Cloudlet cloudlet, List<CloudletExecution> list) {
        return list.stream().filter(cle -> cle.getCloudletId() == cloudlet.getId()).findFirst();
    }

    protected void cloudletFinish(CloudletExecution cle) {
        cle.setStatus(Cloudlet.Status.SUCCESS);
        cle.finalizeCloudlet();
        this.cloudletFinishedList.add(cle);
    }

    @Override
    public boolean cloudletReady(Cloudlet cloudlet) {
        if (this.changeStatusOfCloudletIntoList(this.cloudletPausedList, cloudlet, this::changeToReady)) {
            return true;
        }
        cloudlet.setStatus(Cloudlet.Status.READY);
        Datacenter dc = this.vm.getHost().getDatacenter();
        dc.schedule(CloudSimTag.VM_UPDATE_CLOUDLET_PROCESSING);
        return true;
    }

    private void changeToReady(CloudletExecution cle) {
        this.changeStatusOfCloudlet(cle, cle.getCloudlet().getStatus(), Cloudlet.Status.READY);
    }

    @Override
    public boolean cloudletPause(Cloudlet cloudlet) {
        if (this.changeStatusOfCloudletIntoList(this.cloudletExecList, cloudlet, this::changeInExecToPaused)) {
            return true;
        }
        return this.changeStatusOfCloudletIntoList(this.cloudletWaitingList, cloudlet, this::changeReadyToPaused);
    }

    private void changeInExecToPaused(CloudletExecution cle) {
        this.changeStatusOfCloudlet(cle, Cloudlet.Status.INEXEC, Cloudlet.Status.PAUSED);
        this.removeUsedPes(cle.getPesNumber());
    }

    private void changeReadyToPaused(CloudletExecution cle) {
        this.changeStatusOfCloudlet(cle, Cloudlet.Status.READY, Cloudlet.Status.PAUSED);
    }

    @Override
    public Cloudlet cloudletFail(Cloudlet cloudlet) {
        return this.stopCloudlet(cloudlet, Cloudlet.Status.FAILED);
    }

    @Override
    public Cloudlet cloudletCancel(Cloudlet cloudlet) {
        return this.stopCloudlet(cloudlet, Cloudlet.Status.CANCELED);
    }

    private Cloudlet stopCloudlet(Cloudlet cloudlet, Cloudlet.Status stopStatus) {
        boolean found = this.changeStatusOfCloudletIntoList(this.cloudletFinishedList, cloudlet, cle -> {});
        if (found) {
            return cloudlet;
        }
        found = this.changeStatusOfCloudletIntoList(this.cloudletExecList, cloudlet, cle -> this.changeStatusOfCloudlet((CloudletExecution)cle, Cloudlet.Status.INEXEC, stopStatus));
        if (found) {
            return cloudlet;
        }
        found = this.changeStatusOfCloudletIntoList(this.cloudletPausedList, cloudlet, cle -> this.changeStatusOfCloudlet((CloudletExecution)cle, Cloudlet.Status.PAUSED, stopStatus));
        if (found) {
            return cloudlet;
        }
        this.changeStatusOfCloudletIntoList(this.cloudletWaitingList, cloudlet, cle -> this.changeStatusOfCloudlet((CloudletExecution)cle, Cloudlet.Status.READY, stopStatus));
        if (found) {
            return cloudlet;
        }
        return Cloudlet.NULL;
    }

    private void changeStatusOfCloudlet(CloudletExecution cle, Cloudlet.Status currentStatus, Cloudlet.Status newStatus) {
        if ((currentStatus == Cloudlet.Status.INEXEC || currentStatus == Cloudlet.Status.READY) && cle.getCloudlet().isFinished()) {
            this.cloudletFinish(cle);
        } else {
            cle.setStatus(newStatus);
        }
        if (newStatus == Cloudlet.Status.PAUSED) {
            this.cloudletPausedList.add(cle);
        } else if (newStatus == Cloudlet.Status.READY) {
            this.addCloudletToWaitingList(cle);
        }
    }

    private boolean changeStatusOfCloudletIntoList(List<CloudletExecution> cloudletList, Cloudlet cloudlet, Consumer<CloudletExecution> cloudletStatusUpdaterConsumer) {
        Function<CloudletExecution, Cloudlet> removeCloudletAndUpdateStatus = cle -> {
            cloudletList.remove(cle);
            cloudletStatusUpdaterConsumer.accept((CloudletExecution)cle);
            return cle.getCloudlet();
        };
        return this.findCloudletInList(cloudlet, cloudletList).map(removeCloudletAndUpdateStatus).isPresent();
    }

    @Override
    public double updateProcessing(double currentTime, MipsShare mipsShare) {
        this.setCurrentMipsShare(mipsShare);
        if (this.isEmpty()) {
            this.setPreviousTime(currentTime);
            return Double.MAX_VALUE;
        }
        this.deallocateVmResources();
        double nextSimulationDelay = this.updateCloudletsProcessing(currentTime);
        nextSimulationDelay = Math.min(nextSimulationDelay, this.moveNextCloudletsFromWaitingToExecList(currentTime));
        this.addCloudletsToFinishedList();
        this.setPreviousTime(currentTime);
        this.vm.getSimulation().setLastCloudletProcessingUpdate(currentTime);
        return nextSimulationDelay;
    }

    private void deallocateVmResources() {
        ((VmSimple)this.vm).getRam().deallocateAllResources();
        ((VmSimple)this.vm).getBw().deallocateAllResources();
    }

    private double updateCloudletsProcessing(double currentTime) {
        double nextCloudletFinishTime = Double.MAX_VALUE;
        long usedPes = 0L;
        for (int i = 0; i < this.cloudletExecList.size(); ++i) {
            CloudletExecution cle = this.cloudletExecList.get(i);
            this.updateCloudletProcessingAndPacketsDispatch(cle, currentTime);
            nextCloudletFinishTime = Math.min(nextCloudletFinishTime, this.cloudletEstimatedFinishTime(cle, currentTime));
            usedPes += cle.getCloudlet().getPesNumber();
        }
        ((VmSimple)this.vm).setFreePesNumber(this.vm.getPesNumber() - usedPes);
        return nextCloudletFinishTime;
    }

    private void updateCloudletProcessingAndPacketsDispatch(CloudletExecution cle, double currentTime) {
        long partialFinishedMI = 0L;
        if (this.taskScheduler.isTimeToUpdateCloudletProcessing(cle.getCloudlet())) {
            partialFinishedMI = this.updateCloudletProcessing(cle, currentTime);
        }
        this.taskScheduler.processCloudletTasks(cle.getCloudlet(), partialFinishedMI);
    }

    protected long updateCloudletProcessing(CloudletExecution cle, double currentTime) {
        double partialFinishedInstructions = this.cloudletExecutedInstructionsForTimeSpan(cle, currentTime);
        cle.updateProcessing(partialFinishedInstructions);
        this.updateVmResourceAbsoluteUtilization(cle, ((VmSimple)this.vm).getRam());
        this.updateVmResourceAbsoluteUtilization(cle, ((VmSimple)this.vm).getBw());
        return (long)(partialFinishedInstructions / 1000000.0);
    }

    private void updateVmResourceAbsoluteUtilization(CloudletExecution cle, ResourceManageable vmResource) {
        Cloudlet cloudlet = cle.getCloudlet();
        long requested = (long)this.getCloudletResourceAbsoluteUtilization(cloudlet, vmResource);
        if (requested > vmResource.getCapacity()) {
            LOGGER.warn("{}: {}: {} requested {} {} of {} but that is >= the VM capacity ({})", new Object[]{this.vm.getSimulation().clockStr(), this.getClass().getSimpleName(), cloudlet, requested, vmResource.getUnit(), vmResource.getClass().getSimpleName(), vmResource.getCapacity()});
            return;
        }
        long available = vmResource.getAvailableResource();
        if (requested > available) {
            String msg1 = available > 0L ? "just %d was available".formatted(available) : "no amount is available.";
            String msg2 = vmResource.getClass() == Ram.class ? ". Using Virtual Memory," : ",";
            LOGGER.warn("{}: {}: {} requested {} {} of {} but {}{} which delays Cloudlet processing.", new Object[]{this.vm.getSimulation().clockStr(), this.getClass().getSimpleName(), cloudlet, requested, vmResource.getUnit(), vmResource.getClass().getSimpleName(), msg1, msg2});
            this.updateOnResourceAllocationFailListeners(vmResource, cloudlet, requested, available);
        }
        vmResource.allocateResource(Math.min(requested, available));
    }

    private void updateOnResourceAllocationFailListeners(ResourceManageable resource, Cloudlet cloudlet, long requested, long available) {
        for (int i = this.resourceAllocationFailListeners.size() - 1; i >= 0; --i) {
            EventListener<CloudletResourceAllocationFailEventInfo> listener = this.resourceAllocationFailListeners.get(i);
            listener.update(CloudletResourceAllocationFailEventInfo.of(listener, cloudlet, resource.getClass(), requested, available, this.vm.getSimulation().clock()));
        }
    }

    @Override
    public CloudletScheduler addOnCloudletResourceAllocationFail(EventListener<CloudletResourceAllocationFailEventInfo> listener) {
        if (EventListener.NULL.equals(listener)) {
            return this;
        }
        this.resourceAllocationFailListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public boolean removeOnCloudletResourceAllocationFail(EventListener<CloudletResourceAllocationFailEventInfo> listener) {
        return this.resourceAllocationFailListeners.remove(listener);
    }

    private double getCloudletResourceAbsoluteUtilization(Cloudlet cloudlet, ResourceManageable vmResource) {
        UtilizationModel um = cloudlet.getUtilizationModel(vmResource.getClass());
        return um.getUnit() == UtilizationModel.Unit.ABSOLUTE ? Math.min(um.getUtilization(), (double)vmResource.getCapacity()) : um.getUtilization() * (double)vmResource.getCapacity();
    }

    private double cloudletExecutedInstructionsForTimeSpan(CloudletExecution cle, double currentTime) {
        double processingTimeSpan = this.hasCloudletFileTransferTimePassed(cle, currentTime) ? this.timeSpan(cle, currentTime) : 0.0;
        double vMemDelay = this.getVirtualMemoryDelay(cle, processingTimeSpan);
        double reducedBwDelay = this.getBandwidthOverSubscriptionDelay(cle, processingTimeSpan);
        if (vMemDelay == Double.MIN_VALUE && reducedBwDelay == Double.MIN_VALUE) {
            return 0.0;
        }
        double cloudletUsedMips = this.getAllocatedMipsForCloudlet(cle, currentTime, true);
        double actualProcessingTime = processingTimeSpan - (this.validateDelay(vMemDelay) + this.validateDelay(reducedBwDelay));
        return cloudletUsedMips * actualProcessingTime * 1000000.0;
    }

    private double validateDelay(double delay) {
        return delay == Double.MIN_VALUE ? 0.0 : delay;
    }

    private double getVirtualMemoryDelay(CloudletExecution cle, double processingTimeSpan) {
        return this.getResourceOverSubscriptionDelay(cle, processingTimeSpan, ((VmSimple)this.vm).getRam(), (vmRam, requestedRam) -> requestedRam <= (double)vmRam.getCapacity() && requestedRam <= (double)this.vm.getStorage().getAvailableResource(), (notAllocatedRam, __) -> this.diskTransferTime(cle, (Double)notAllocatedRam));
    }

    private double diskTransferTime(CloudletExecution cle, Double dataSize) {
        return ((FileStorage)cle.getCloudlet().getVm().getHost().getStorage()).getTransferTime(dataSize.intValue());
    }

    private double getBandwidthOverSubscriptionDelay(CloudletExecution cle, double processingTimeSpan) {
        return this.getResourceOverSubscriptionDelay(cle, processingTimeSpan, ((VmSimple)this.vm).getBw(), (vmBw, requestedBw) -> requestedBw <= (double)vmBw.getCapacity(), (notAllocatedBw, requestedBw) -> requestedBw / (requestedBw - notAllocatedBw) - 1.0);
    }

    private double getResourceOverSubscriptionDelay(CloudletExecution cle, double processingTimeSpan, ResourceManageable vmResource, BiPredicate<ResourceManageable, Double> suitableCapacityPredicate, BiFunction<Double, Double, Double> delayFunction) {
        double requestedResource = this.getCloudletResourceAbsoluteUtilization(cle.getCloudlet(), vmResource);
        if (!suitableCapacityPredicate.test(vmResource, requestedResource)) {
            cle.incOverSubscriptionDelay(processingTimeSpan);
            return Double.MIN_VALUE;
        }
        double notAllocatedResource = Math.max(requestedResource - (double)vmResource.getAvailableResource(), 0.0);
        if (notAllocatedResource > 0.0) {
            double delay = delayFunction.apply(notAllocatedResource, requestedResource);
            cle.incOverSubscriptionDelay(delay);
            return delay;
        }
        return 0.0;
    }

    private boolean hasCloudletFileTransferTimePassed(CloudletExecution cle, double currentTime) {
        return cle.getFileTransferTime() == 0.0 || currentTime - cle.getCloudletArrivalTime() > cle.getFileTransferTime() || cle.getCloudlet().getFinishedLengthSoFar() > 0L;
    }

    protected double timeSpan(CloudletExecution cle, double currentTime) {
        return currentTime - cle.getLastProcessingTime();
    }

    private int addCloudletsToFinishedList() {
        List finishedCloudlets = this.cloudletExecList.stream().filter(cle -> cle.getCloudlet().isFinished()).collect(Collectors.toList());
        for (CloudletExecution c : finishedCloudlets) {
            this.addCloudletToFinishedList(c);
        }
        return finishedCloudlets.size();
    }

    private void addCloudletToFinishedList(CloudletExecution cle) {
        this.setCloudletFinishTimeAndAddToFinishedList(cle);
        this.removeCloudletFromExecList(cle);
    }

    protected CloudletExecution removeCloudletFromExecList(CloudletExecution cle) {
        this.removeUsedPes(cle.getPesNumber());
        return this.cloudletExecList.remove(cle) ? cle : CloudletExecution.NULL;
    }

    private void setCloudletFinishTimeAndAddToFinishedList(CloudletExecution cle) {
        double clock = this.vm.getSimulation().clock();
        this.cloudletFinish(cle);
        cle.setFinishTime(clock);
    }

    protected double cloudletEstimatedFinishTime(CloudletExecution cle, double currentTime) {
        double cloudletAllocatedMips = this.getAllocatedMipsForCloudlet(cle, currentTime);
        cle.setLastAllocatedMips(cloudletAllocatedMips);
        double remainingLifeTime = cle.getRemainingLifeTime();
        double finishTimeForRemainingLen = (double)cle.getRemainingCloudletLength() / cle.getLastAllocatedMips();
        double estimatedFinishTime = Math.min(remainingLifeTime, finishTimeForRemainingLen);
        return Math.max(estimatedFinishTime, this.vm.getSimulation().getMinTimeBetweenEvents());
    }

    protected double moveNextCloudletsFromWaitingToExecList(double currentTime) {
        Optional<CloudletExecution> optional = Optional.of(CloudletExecution.NULL);
        double nextCloudletFinishTime = Double.MAX_VALUE;
        while (!this.cloudletWaitingList.isEmpty() && optional.isPresent()) {
            optional = this.findSuitableWaitingCloudlet();
            double estimatedFinishTime = optional.map(this::addWaitingCloudletToExecList).map(cle -> this.cloudletEstimatedFinishTime((CloudletExecution)cle, currentTime)).orElse((Double)Double.MAX_VALUE);
            nextCloudletFinishTime = Math.min(nextCloudletFinishTime, estimatedFinishTime);
        }
        return nextCloudletFinishTime;
    }

    protected Optional<CloudletExecution> findSuitableWaitingCloudlet() {
        return this.cloudletWaitingList.stream().filter(cle -> cle.getCloudlet().getStatus() != Cloudlet.Status.FROZEN).filter(this::canExecuteCloudlet).findFirst();
    }

    protected boolean isThereEnoughFreePesForCloudlet(CloudletExecution cle) {
        return this.vm.getProcessor().getAvailableResource() >= cle.getPesNumber();
    }

    protected CloudletExecution addWaitingCloudletToExecList(CloudletExecution cle) {
        this.cloudletWaitingList.remove(cle);
        this.addCloudletToExecList(cle);
        return cle;
    }

    @Override
    public void setVm(@NonNull Vm vm) {
        if (vm == null) {
            throw new NullPointerException("vm is marked non-null but is null");
        }
        if (this.isOtherVmAssigned(vm)) {
            throw new IllegalArgumentException("CloudletScheduler already has a Vm assigned to it. Each Vm must have its own CloudletScheduler instance.");
        }
        this.vm = vm;
    }

    private boolean isOtherVmAssigned(Vm vm) {
        return this.vm != null && this.vm != Vm.NULL && !vm.equals(this.vm);
    }

    @Override
    public long getUsedPes() {
        return this.vm.getProcessor().getAllocatedResource();
    }

    @Override
    public long getFreePes() {
        return this.currentMipsShare.pes() - this.getUsedPes();
    }

    private void addUsedPes(long usedPesToAdd) {
        this.vm.getProcessor().allocateResource(usedPesToAdd);
    }

    private void removeUsedPes(long usedPesToRemove) {
        this.vm.getProcessor().deallocateResource(usedPesToRemove);
    }

    @Override
    public void setTaskScheduler(CloudletTaskScheduler taskScheduler) {
        this.taskScheduler = Objects.requireNonNull(taskScheduler);
        this.taskScheduler.setVm(this.vm);
    }

    @Override
    public boolean isThereTaskScheduler() {
        return this.taskScheduler != null && this.taskScheduler != CloudletTaskScheduler.NULL;
    }

    @Override
    public double getRequestedCpuPercent(double time) {
        return this.getRequestedOrAllocatedCpuPercentUtilization(time, true);
    }

    @Override
    public double getAllocatedCpuPercent(double time) {
        return this.getRequestedOrAllocatedCpuPercentUtilization(time, false);
    }

    private double getRequestedOrAllocatedCpuPercentUtilization(double time, boolean requestedUtilization) {
        return this.cloudletExecList.stream().map(CloudletExecution::getCloudlet).mapToDouble(cloudlet -> this.getAbsoluteCloudletCpuUtilizationForAllPes(time, (Cloudlet)cloudlet, requestedUtilization)).sum() / this.vm.getTotalMipsCapacity();
    }

    private double getAbsoluteCloudletCpuUtilizationForAllPes(double time, Cloudlet cloudlet, boolean requestedUtilization) {
        double cloudletCpuUsageForOnePe = this.getAbsoluteCloudletResourceUtilization(cloudlet, cloudlet.getUtilizationModelCpu(), time, this.getAvailableMipsByPe(), "CPU", requestedUtilization);
        return cloudletCpuUsageForOnePe * (double)cloudlet.getPesNumber();
    }

    protected double getRequestedMipsForCloudlet(CloudletExecution cle, double time) {
        Cloudlet cloudlet = cle.getCloudlet();
        return this.getAbsoluteCloudletResourceUtilization(cloudlet, cloudlet.getUtilizationModelCpu(), time, this.vm.getMips(), "CPU", true);
    }

    public double getAllocatedMipsForCloudlet(CloudletExecution cle, double time) {
        return this.getAllocatedMipsForCloudlet(cle, time, false);
    }

    public double getAllocatedMipsForCloudlet(CloudletExecution cle, double time, boolean log) {
        Cloudlet cloudlet = cle.getCloudlet();
        String resourceName = log ? "CPU" : "";
        return this.getAbsoluteCloudletResourceUtilization(cloudlet, cloudlet.getUtilizationModelCpu(), time, this.getAvailableMipsByPe(), resourceName, false);
    }

    @Override
    public double getCurrentRequestedBwPercentUtilization() {
        return this.cloudletExecList.stream().map(CloudletExecution::getCloudlet).mapToDouble(cl -> this.getAbsoluteCloudletResourceUtilization((Cloudlet)cl, cl.getUtilizationModelBw(), this.vm.getBw().getCapacity(), "BW")).sum() / (double)this.vm.getBw().getCapacity();
    }

    @Override
    public double getCurrentRequestedRamPercentUtilization() {
        return this.cloudletExecList.stream().map(CloudletExecution::getCloudlet).mapToDouble(cl -> this.getAbsoluteCloudletResourceUtilization((Cloudlet)cl, cl.getUtilizationModelRam(), this.vm.getRam().getCapacity(), "RAM")).sum() / (double)this.vm.getRam().getCapacity();
    }

    private double getAbsoluteCloudletResourceUtilization(Cloudlet cloudlet, UtilizationModel model, double maxResourceAllowedToUse, String resource) {
        return this.getAbsoluteCloudletResourceUtilization(cloudlet, model, this.vm.getSimulation().clock(), maxResourceAllowedToUse, resource, true);
    }

    private double getAbsoluteCloudletResourceUtilization(Cloudlet cloudlet, UtilizationModel model, double time, double maxResourceAllowedToUse, String resourceName, boolean requestedUtilization) {
        double allocatedPercent;
        if (model.getUnit() == UtilizationModel.Unit.ABSOLUTE) {
            return Math.min(model.getUtilization(time), maxResourceAllowedToUse);
        }
        double requestedPercent = model.getUtilization();
        double d = allocatedPercent = requestedUtilization ? requestedPercent : Math.min(requestedPercent, 1.0);
        if (requestedPercent > 1.0 && !requestedUtilization && !resourceName.isEmpty()) {
            LOGGER.warn("{}: {}: {} is requesting {}% of the total {} capacity which cannot be allocated. Allocating {}%.", new Object[]{this.vm.getSimulation().clockStr(), this.getClass().getSimpleName(), cloudlet, requestedPercent * 100.0, resourceName, allocatedPercent * 100.0});
        }
        return allocatedPercent * maxResourceAllowedToUse;
    }

    protected Set<Cloudlet> getCloudletReturnedList() {
        return Collections.unmodifiableSet(this.cloudletReturnedList);
    }

    @Override
    public void addCloudletToReturnedList(Cloudlet cloudlet) {
        this.cloudletReturnedList.add(cloudlet);
    }

    @Override
    public void deallocatePesFromVm(long pesToRemove) {
        long removedPes = this.currentMipsShare.remove(pesToRemove);
        this.removeUsedPes(removedPes);
    }

    @Override
    public List<Cloudlet> getCloudletList() {
        return Stream.concat(this.cloudletExecList.stream(), this.cloudletWaitingList.stream()).map(CloudletExecution::getCloudlet).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @Override
    public boolean isEmpty() {
        return this.cloudletExecList.isEmpty() && this.cloudletWaitingList.isEmpty();
    }

    private boolean canExecuteCloudlet(CloudletExecution cle) {
        return cle.getCloudlet().getStatus().ordinal() < Cloudlet.Status.FROZEN.ordinal() && this.canExecuteCloudletInternal(cle);
    }

    protected abstract boolean canExecuteCloudletInternal(CloudletExecution var1);

    @Override
    public void clear() {
        this.cloudletWaitingList.clear();
        this.cloudletExecList.clear();
    }

    @Override
    public final Vm getVm() {
        return this.vm;
    }

    @Override
    public final CloudletTaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public final MipsShare getCurrentMipsShare() {
        return this.currentMipsShare;
    }

    @Override
    public final double getPreviousTime() {
        return this.previousTime;
    }

    @Override
    public final List<CloudletExecution> getCloudletFinishedList() {
        return this.cloudletFinishedList;
    }

    public final List<CloudletExecution> getCloudletPausedList() {
        return this.cloudletPausedList;
    }

    public final List<CloudletExecution> getCloudletFailedList() {
        return this.cloudletFailedList;
    }

    @Override
    public final boolean isCloudletSubmittedListEnabled() {
        return this.cloudletSubmittedListEnabled;
    }
}

