/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.schedulers;

import lombok.NonNull;
import org.cloudsimplus.resources.Processor;
import org.cloudsimplus.util.MathUtil;

public class MipsShare {
    public static final MipsShare NULL = new MipsShare();
    private long pes;
    private double mips;

    public MipsShare() {
        this(0L, 0.0);
    }

    public MipsShare(double mips) {
        this(1L, mips);
    }

    public MipsShare(@NonNull Processor processor) {
        this(processor.getCapacity(), processor.getMips());
        if (processor == null) {
            throw new NullPointerException("processor is marked non-null but is null");
        }
    }

    public MipsShare(long pes, double mips) {
        this.pes = MathUtil.nonNegative(pes, "PEs number");
        this.setMips(mips);
    }

    public MipsShare(@NonNull MipsShare share) {
        this(share.pes, share.mips);
        if (share == null) {
            throw new NullPointerException("share is marked non-null but is null");
        }
    }

    public double mips() {
        return this.mips;
    }

    public final void setMips(double mips) {
        this.mips = MathUtil.nonNegative(mips, "MIPS");
    }

    public long pes() {
        return this.pes;
    }

    public boolean isEmpty() {
        return this.pes == 0L || this.mips == 0.0;
    }

    public double totalMips() {
        return (double)this.pes * this.mips;
    }

    public long remove(long count) {
        MathUtil.nonNegative(count, "Number of PEs to remove");
        long removedPes = Math.min(count, this.pes);
        this.pes -= removedPes;
        return count;
    }

    public String toString() {
        return "MipsShare{pes=" + this.pes + ", mips=" + this.mips + "}";
    }
}

