/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.resources;

import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.cloudsimplus.resources.Resource;
import org.cloudsimplus.util.MathUtil;

public abstract class ResourceAbstract
implements Resource {
    protected long capacity;
    private final String unit;

    public ResourceAbstract(long capacity, @NonNull String unit) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        this.capacity = MathUtil.nonNegative(capacity, "Capacity");
        if (StringUtils.isBlank((CharSequence)unit)) {
            throw new IllegalArgumentException("Resource measurement unit cannot empty");
        }
        this.unit = unit;
    }

    @Override
    public long getAllocatedResource() {
        return this.getCapacity() - this.getAvailableResource();
    }

    @Override
    public boolean isAmountAvailable(long amountToCheck) {
        return this.getAvailableResource() >= amountToCheck;
    }

    @Override
    public boolean isAmountAvailable(double amountToCheck) {
        return this.isAmountAvailable((long)amountToCheck);
    }

    public boolean isResourceAmountBeingUsed(long amountToCheck) {
        return this.getAllocatedResource() >= amountToCheck;
    }

    public boolean isSuitable(long newTotalAllocatedResource) {
        if (newTotalAllocatedResource <= this.getAllocatedResource()) {
            return true;
        }
        long allocationDifference = newTotalAllocatedResource - this.getAllocatedResource();
        return this.isAmountAvailable(allocationDifference);
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }
}

