/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.resources;

import lombok.NonNull;
import org.cloudsimplus.provisioners.PeProvisioner;
import org.cloudsimplus.provisioners.PeProvisionerSimple;
import org.cloudsimplus.resources.Pe;
import org.cloudsimplus.resources.ResourceManageableAbstract;

public class PeSimple
extends ResourceManageableAbstract
implements Pe {
    private static double defaultMips = 1000.0;
    private long id;
    private Pe.Status status;
    private PeProvisioner peProvisioner;

    public PeSimple() {
        this(defaultMips);
    }

    public PeSimple(double mipsCapacity) {
        this(mipsCapacity, new PeProvisionerSimple());
    }

    public PeSimple(double mipsCapacity, PeProvisioner peProvisioner) {
        super((long)mipsCapacity, "Unit");
        this.setId(-1L);
        this.setPeProvisioner(peProvisioner);
        this.setStatus(Pe.Status.FREE);
    }

    public PeSimple(int id, double mipsCapacity, PeProvisioner peProvisioner) {
        this(mipsCapacity, peProvisioner);
        this.setId(id);
    }

    public static double getDefaultMips() {
        return defaultMips;
    }

    public static void setDefaultMips(double defaultMips) {
        PeSimple.defaultMips = defaultMips;
    }

    @Override
    public boolean setCapacity(double mipsCapacity) {
        return this.setCapacity((long)mipsCapacity);
    }

    @Override
    public final Pe setPeProvisioner(@NonNull PeProvisioner peProvisioner) {
        if (peProvisioner == null) {
            throw new NullPointerException("peProvisioner is marked non-null but is null");
        }
        this.peProvisioner = peProvisioner;
        this.peProvisioner.setPe(this);
        return this;
    }

    @Override
    public String toString() {
        return "%s %d: %s".formatted(new Object[]{this.getClass().getSimpleName(), this.id, this.status});
    }

    @Override
    public boolean isWorking() {
        return !this.isFailed();
    }

    @Override
    public boolean isFailed() {
        return Pe.Status.FAILED.equals((Object)this.status);
    }

    @Override
    public boolean isFree() {
        return Pe.Status.FREE.equals((Object)this.status);
    }

    @Override
    public boolean isBusy() {
        return Pe.Status.BUSY.equals((Object)this.status);
    }

    @Override
    public final long getId() {
        return this.id;
    }

    @Override
    public final Pe.Status getStatus() {
        return this.status;
    }

    @Override
    public final PeProvisioner getPeProvisioner() {
        return this.peProvisioner;
    }

    @Override
    public final PeSimple setId(long id) {
        this.id = id;
        return this;
    }

    @Override
    public final PeSimple setStatus(Pe.Status status) {
        this.status = status;
        return this;
    }
}

