/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.resources;

import java.time.LocalDateTime;
import lombok.NonNull;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.resources.FileAttribute;
import org.cloudsimplus.util.MathUtil;

public class File {
    public static final int NOT_REGISTERED = -1;
    public static final int TYPE_UNKNOWN = 0;
    private String name;
    @NonNull
    private Datacenter datacenter = Datacenter.NULL;
    private FileAttribute attribute;
    private double transactionTime;
    private boolean deleted;

    public File(String fileName, int fileSize) {
        this.setName(fileName);
        this.setTransactionTime(0.0);
        this.createAttribute(fileSize);
    }

    public File(File file) throws IllegalArgumentException {
        this(file, false);
    }

    protected File(@NonNull File file, boolean masterCopy) throws IllegalArgumentException {
        this(file.getName(), file.getSize());
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.setDatacenter(file.getDatacenter());
        this.deleted = file.deleted;
        file.getAttribute().copyValue(this.attribute);
        this.attribute.setMasterCopy(masterCopy);
    }

    public static void validate(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        File.validate(file.getName());
    }

    public static String validate(@NonNull String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (fileName.isBlank()) {
            throw new IllegalArgumentException("File name cannot be blank");
        }
        return fileName;
    }

    protected void createAttribute(int fileSize) {
        this.attribute = new FileAttribute(this, fileSize);
    }

    public File makeReplica() {
        return this.makeCopy();
    }

    public File makeMasterCopy() {
        return this.makeCopy().setMasterCopy(true);
    }

    private File makeCopy() {
        File file = new File(this.name, this.attribute.getFileSize());
        this.attribute.copyValue(file.attribute);
        file.attribute.setMasterCopy(false);
        return file;
    }

    public int getAttributeSize() {
        return this.attribute.getAttributeSize();
    }

    public final void setName(String name) {
        this.name = File.validate(name);
    }

    public void setOwnerName(String name) {
        this.attribute.setOwnerName(name);
    }

    public String getOwnerName() {
        return this.attribute.getOwnerName();
    }

    public int getSize() {
        return this.attribute.getFileSize();
    }

    public int getSizeInByte() {
        return this.attribute.getFileSizeInByte();
    }

    public void setSize(int fileSize) {
        this.attribute.setFileSize(fileSize);
    }

    public boolean setUpdateTime(double time) {
        return this.attribute.setLastUpdateTime(time);
    }

    public double getLastUpdateTime() {
        return this.attribute.getLastUpdateTime();
    }

    public boolean setRegistrationID(int id) {
        return this.attribute.setRegistrationId(id);
    }

    public long getRegistrationID() {
        return this.attribute.getRegistrationID();
    }

    public void setType(int type) {
        this.attribute.setType(type);
    }

    public int getType() {
        return this.attribute.getType();
    }

    public void setChecksum(int checksum) {
        this.attribute.setChecksum(checksum);
    }

    public int getChecksum() {
        return this.attribute.getChecksum();
    }

    public void setCost(double cost) {
        this.attribute.setCost(cost);
    }

    public double getCost() {
        return this.attribute.getCost();
    }

    public LocalDateTime getCreationTime() {
        return this.attribute.getCreationTime();
    }

    public boolean isRegistered() {
        return this.attribute.isRegistered();
    }

    public boolean isMasterCopy() {
        return this.attribute.isMasterCopy();
    }

    public File setMasterCopy(boolean masterCopy) {
        this.attribute.setMasterCopy(masterCopy);
        return this;
    }

    public final void setTransactionTime(double time) {
        this.transactionTime = MathUtil.nonNegative(time, "transactionTime");
    }

    public String toString() {
        return this.name;
    }

    public final String getName() {
        return this.name;
    }

    @NonNull
    public final Datacenter getDatacenter() {
        return this.datacenter;
    }

    public final FileAttribute getAttribute() {
        return this.attribute;
    }

    public final double getTransactionTime() {
        return this.transactionTime;
    }

    public final boolean isDeleted() {
        return this.deleted;
    }

    public final File setDatacenter(@NonNull Datacenter datacenter) {
        if (datacenter == null) {
            throw new NullPointerException("datacenter is marked non-null but is null");
        }
        this.datacenter = datacenter;
        return this;
    }

    public final File setAttribute(FileAttribute attribute) {
        this.attribute = attribute;
        return this;
    }

    public final File setDeleted(boolean deleted) {
        this.deleted = deleted;
        return this;
    }
}

