/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.provisioners;

import lombok.NonNull;
import org.cloudsimplus.provisioners.PeProvisioner;
import org.cloudsimplus.provisioners.ResourceProvisionerSimple;
import org.cloudsimplus.resources.Pe;
import org.cloudsimplus.resources.ResourceManageable;
import org.cloudsimplus.vms.Vm;

public class PeProvisionerSimple
extends ResourceProvisionerSimple
implements PeProvisioner {
    public PeProvisionerSimple() {
        super(Pe.NULL, vm -> ResourceManageable.NULL);
    }

    public PeProvisionerSimple(Pe pe) {
        super(pe, Vm::getProcessor);
        pe.setPeProvisioner(this);
    }

    @Override
    public void setPe(Pe pe) {
        if (this.isOtherProvisionerAssignedToPe(pe)) {
            throw new IllegalArgumentException("Pe already has a PeProvisioner assigned to it. Each Pe must have its own PeProvisioner instance.");
        }
        this.setResources(pe, Vm::getProcessor);
    }

    @Override
    public double getUtilization() {
        return (double)this.getTotalAllocatedResource() / (double)this.getCapacity();
    }

    private boolean isOtherProvisionerAssignedToPe(@NonNull Pe pe) {
        if (pe == null) {
            throw new NullPointerException("pe is marked non-null but is null");
        }
        return pe.getPeProvisioner() != null && pe.getPeProvisioner() != PeProvisioner.NULL && !pe.getPeProvisioner().equals(this);
    }
}

