/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.power.models;

import java.util.List;
import lombok.NonNull;
import org.cloudsimplus.power.PowerMeasurement;
import org.cloudsimplus.power.models.PowerModelHost;

public class PowerModelHostSpec
extends PowerModelHost {
    public static final int MIN_POWER_CONSUMPTION_DATA_SIZE = 2;
    private final List<Double> powerSpec;

    public PowerModelHostSpec(@NonNull List<Double> powerSpec) {
        if (powerSpec == null) {
            throw new NullPointerException("powerSpec is marked non-null but is null");
        }
        if (powerSpec.size() >= 2) {
            this.powerSpec = powerSpec;
            return;
        }
        String msg = "powerSpec has to contain at least %d elements (representing utilization at 0%% and 100%% load, respectively)".formatted(2);
        throw new IllegalArgumentException(msg);
    }

    @Override
    public PowerMeasurement getPowerMeasurement() {
        double utilizationFraction = this.getHost().getCpuMipsUtilization() / this.getHost().getTotalMipsCapacity();
        int utilizationIndex = (int)Math.round(utilizationFraction * (double)this.powerSpec.size());
        double powerUsage = this.powerSpec.get(utilizationIndex);
        return new PowerMeasurement(this.powerSpec.get(0), powerUsage - this.powerSpec.get(0));
    }

    @Override
    public double getPowerInternal(double utilizationFraction) {
        int utilizationIndex = (int)Math.round(utilizationFraction * (double)this.powerSpec.size());
        return this.powerSpec.get(utilizationIndex);
    }
}

