/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.power.models;

import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.power.PowerMeasurement;
import org.cloudsimplus.power.models.PowerModelHost;

public class PowerModelHostSimple
extends PowerModelHost {
    private final double maxPower;
    private final double staticPower;

    public PowerModelHostSimple(double maxPower, double staticPower) {
        if (maxPower < staticPower) {
            throw new IllegalArgumentException("maxPower has to be higher than staticPower");
        }
        this.maxPower = PowerModelHostSimple.validatePower(maxPower, "maxPower");
        this.staticPower = PowerModelHostSimple.validatePower(staticPower, "staticPower");
    }

    @Override
    public PowerMeasurement getPowerMeasurement() {
        Host host = this.getHost();
        if (!host.isActive()) {
            return new PowerMeasurement();
        }
        double usageFraction = host.getCpuMipsUtilization() / host.getTotalMipsCapacity();
        return new PowerMeasurement(this.staticPower, this.dynamicPower(usageFraction));
    }

    @Override
    public double getPowerInternal(double utilizationFraction) {
        return this.staticPower + this.dynamicPower(utilizationFraction);
    }

    private double dynamicPower(double utilizationFraction) {
        return (this.maxPower - this.staticPower) * utilizationFraction;
    }

    public final double getMaxPower() {
        return this.maxPower;
    }

    public final double getStaticPower() {
        return this.staticPower;
    }
}

