/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.power.models;

import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.power.models.PowerModel;
import org.cloudsimplus.power.models.PowerModelHostNull;
import org.cloudsimplus.util.MathUtil;

public abstract class PowerModelHost
implements PowerModel {
    public static final PowerModelHost NULL = new PowerModelHostNull();
    private Host host;
    private double startupDelay;
    private double shutDownDelay;
    private double startupPower;
    private double shutDownPower;
    private double totalStartupPower;
    private double totalShutDownPower;
    private double totalStartupTime;
    private double totalShutDownTime;
    private int totalStartups;

    protected static double validatePower(double power, String fieldName) {
        MathUtil.nonNegative(power, fieldName);
        String s = "%s must be in watts. A value smaller than 1 may indicate you're trying to give a percentage value instead.";
        if (power < 1.0) {
            throw new IllegalArgumentException("%s must be in watts. A value smaller than 1 may indicate you're trying to give a percentage value instead.".formatted(fieldName));
        }
        return power;
    }

    public final double getPower(double utilizationFraction) {
        MathUtil.percentage(utilizationFraction, "utilizationFraction");
        return this.getPowerInternal(utilizationFraction);
    }

    protected abstract double getPowerInternal(double var1);

    public PowerModelHost setStartupDelay(double delay) {
        this.startupDelay = MathUtil.nonNegative(delay, "Startup Delay");
        return this;
    }

    public PowerModelHost setShutDownDelay(double delay) {
        this.shutDownDelay = MathUtil.nonNegative(delay, "Shutdown Delay");
        return this;
    }

    public PowerModelHost setStartupPower(double power) {
        this.startupPower = PowerModelHost.validatePower(power, "Power");
        return this;
    }

    public PowerModelHost setShutDownPower(double power) {
        this.shutDownPower = PowerModelHost.validatePower(power, "Power");
        return this;
    }

    public void addStartupTotals() {
        this.totalStartupPower += this.startupPower;
        this.totalStartupTime += this.startupDelay;
        ++this.totalStartups;
    }

    public void addShutDownTotals() {
        this.totalShutDownPower += this.shutDownPower;
        this.totalShutDownTime += this.shutDownDelay;
    }

    public Host getHost() {
        return this.host;
    }

    public PowerModelHost setHost(Host host) {
        this.host = host;
        return this;
    }

    public double getStartupDelay() {
        return this.startupDelay;
    }

    public double getShutDownDelay() {
        return this.shutDownDelay;
    }

    public double getStartupPower() {
        return this.startupPower;
    }

    public double getShutDownPower() {
        return this.shutDownPower;
    }

    public double getTotalStartupPower() {
        return this.totalStartupPower;
    }

    public double getTotalShutDownPower() {
        return this.totalShutDownPower;
    }

    public double getTotalStartupTime() {
        return this.totalStartupTime;
    }

    public double getTotalShutDownTime() {
        return this.totalShutDownTime;
    }

    public int getTotalStartups() {
        return this.totalStartups;
    }
}

