/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.power.models;

import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.power.PowerMeasurement;
import org.cloudsimplus.power.models.PowerModel;
import org.cloudsimplus.power.models.PowerModelDatacenter;
import org.cloudsimplus.util.MathUtil;

public class PowerModelDatacenterSimple
extends PowerModelDatacenter {
    private double powerUsageEffectiveness = 1.0;

    public PowerModelDatacenterSimple(Datacenter datacenter) {
        this.setDatacenter(datacenter);
    }

    @Override
    public PowerMeasurement getPowerMeasurement() {
        PowerMeasurement measurement = this.getDatacenter().getHostList().stream().map(Host::getPowerModel).map(PowerModel::getPowerMeasurement).reduce(PowerMeasurement::add).orElse(new PowerMeasurement());
        return measurement.multiply(this.powerUsageEffectiveness);
    }

    public void setPowerUsageEffectiveness(double powerUsageEffectiveness) {
        this.powerUsageEffectiveness = MathUtil.percentage(powerUsageEffectiveness, "powerUsageEffectiveness");
    }

    public final double getPowerUsageEffectiveness() {
        return this.powerUsageEffectiveness;
    }
}

