/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.network.topologies;

import lombok.NonNull;
import org.cloudsimplus.network.topologies.Point2D;

public final class TopologicalNode {
    private int id;
    @NonNull
    private String nodeName;
    @NonNull
    private Point2D worldCoordinates;

    public TopologicalNode() {
        this(0);
    }

    public TopologicalNode(int id) {
        this(id, new Point2D());
    }

    public TopologicalNode(int id, Point2D worldCoordinates) {
        this(id, String.valueOf(id), worldCoordinates);
    }

    public TopologicalNode(int id, String nodeName, Point2D worldCoordinates) {
        this.setId(id);
        this.setNodeName(nodeName);
        this.setWorldCoordinates(worldCoordinates);
    }

    public final int getId() {
        return this.id;
    }

    @NonNull
    public final String getNodeName() {
        return this.nodeName;
    }

    @NonNull
    public final Point2D getWorldCoordinates() {
        return this.worldCoordinates;
    }

    public final TopologicalNode setId(int id) {
        this.id = id;
        return this;
    }

    public final TopologicalNode setNodeName(@NonNull String nodeName) {
        if (nodeName == null) {
            throw new NullPointerException("nodeName is marked non-null but is null");
        }
        this.nodeName = nodeName;
        return this;
    }

    public final TopologicalNode setWorldCoordinates(@NonNull Point2D worldCoordinates) {
        if (worldCoordinates == null) {
            throw new NullPointerException("worldCoordinates is marked non-null but is null");
        }
        this.worldCoordinates = worldCoordinates;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopologicalNode)) {
            return false;
        }
        TopologicalNode other = (TopologicalNode)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        return result;
    }
}

