/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.network.switches;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.cloudsimplus.core.CloudSimPlus;
import org.cloudsimplus.core.events.SimEvent;
import org.cloudsimplus.datacenters.network.NetworkDatacenter;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.hosts.network.NetworkHost;
import org.cloudsimplus.network.HostPacket;
import org.cloudsimplus.network.switches.AbstractSwitch;
import org.cloudsimplus.vms.network.NetworkVm;

public class EdgeSwitch
extends AbstractSwitch {
    public static final int LEVEL = 2;
    public static final int PORTS = 4;
    private static final long DEF_DOWNLINK_BW = 800L;
    private static final double DEF_SWITCHING_DELAY = 0.00157;
    private final List<NetworkHost> hostList = new ArrayList<NetworkHost>();

    public EdgeSwitch(CloudSimPlus simulation, NetworkDatacenter dc) {
        super(simulation, dc);
        this.setUplinkBandwidth(8.388608E8);
        this.setDownlinkBandwidth(800.0);
        this.setSwitchingDelay(0.00157);
        this.setPorts(4);
    }

    @Override
    protected void processPacketDown(SimEvent evt) {
        super.processPacketDown(evt);
        HostPacket pkt = this.extractReceivedHostPacket(evt);
        this.addPacketToSendToHost(pkt.getDestination(), pkt);
    }

    private HostPacket extractReceivedHostPacket(SimEvent evt) {
        HostPacket pkt = (HostPacket)evt.getData();
        NetworkVm receiverVm = pkt.getVmPacket().getDestination();
        NetworkHost host = this.getVmHost(receiverVm);
        pkt.setDestination(host);
        return pkt;
    }

    @Override
    protected void processPacketUp(SimEvent evt) {
        super.processPacketUp(evt);
        HostPacket pkt = this.extractReceivedHostPacket(evt);
        if (pkt.getDestination() != null && pkt.getDestination() != Host.NULL) {
            this.addPacketToSendToHost(pkt.getDestination(), pkt);
            return;
        }
        this.addPacketToBeSentToFirstUplinkSwitch(pkt);
    }

    @Override
    public int getLevel() {
        return 2;
    }

    public List<NetworkHost> getHostList() {
        return Collections.unmodifiableList(this.hostList);
    }

    public void connectHost(@NonNull NetworkHost host) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        this.hostList.add(host);
        host.setEdgeSwitch(this);
    }

    public boolean disconnectHost(@NonNull NetworkHost host) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        if (this.hostList.remove(host)) {
            host.setEdgeSwitch(null);
            return true;
        }
        return false;
    }
}

