/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.network.switches;

import org.cloudsimplus.core.CloudSimPlus;
import org.cloudsimplus.core.events.SimEvent;
import org.cloudsimplus.datacenters.network.NetworkDatacenter;
import org.cloudsimplus.network.HostPacket;
import org.cloudsimplus.network.switches.AbstractSwitch;
import org.cloudsimplus.network.switches.EdgeSwitch;
import org.cloudsimplus.network.switches.RootSwitch;
import org.cloudsimplus.network.switches.Switch;

public class AggregateSwitch
extends AbstractSwitch {
    public static final int LEVEL = 1;
    public static final double SWITCHING_DELAY = 0.00245;
    public static final long DOWNLINK_BW = 0x32000000L;
    public static final int PORTS = 1;

    public AggregateSwitch(CloudSimPlus simulation, NetworkDatacenter dc) {
        super(simulation, dc);
        this.setUplinkBandwidth(RootSwitch.DOWNLINK_BW);
        this.setDownlinkBandwidth(8.388608E8);
        this.setSwitchingDelay(0.00245);
        this.setPorts(1);
    }

    @Override
    protected void processPacketDown(SimEvent evt) {
        super.processPacketDown(evt);
        HostPacket netPkt = (HostPacket)evt.getData();
        EdgeSwitch downlinkSw = netPkt.getVmEdgeSwitch();
        this.addPacketToSendToDownlinkSwitch(downlinkSw, netPkt);
    }

    @Override
    protected void processPacketUp(SimEvent evt) {
        super.processPacketUp(evt);
        HostPacket netPkt = (HostPacket)evt.getData();
        EdgeSwitch downlinkSw = netPkt.getVmEdgeSwitch();
        if (this.findConnectedEdgeSwitch(downlinkSw)) {
            this.addPacketToSendToDownlinkSwitch(downlinkSw, netPkt);
        } else {
            this.addPacketToBeSentToFirstUplinkSwitch(netPkt);
        }
    }

    private boolean findConnectedEdgeSwitch(Switch edgeSwitch) {
        return this.getDownlinkSwitches().stream().anyMatch(edgeSwitch::equals);
    }

    @Override
    public int getLevel() {
        return 1;
    }
}

