/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.network;

import lombok.NonNull;
import org.cloudsimplus.cloudlets.network.NetworkCloudlet;
import org.cloudsimplus.hosts.network.NetworkHost;
import org.cloudsimplus.network.NetworkPacket;
import org.cloudsimplus.vms.network.NetworkVm;

public class VmPacket
implements NetworkPacket<NetworkVm> {
    @NonNull
    private NetworkVm source;
    @NonNull
    private NetworkVm destination;
    @NonNull
    private final NetworkCloudlet senderCloudlet;
    @NonNull
    private final NetworkCloudlet receiverCloudlet;
    private final long size;
    private double sendTime;
    private double receiveTime;

    public VmPacket(NetworkVm sourceVm, NetworkVm destinationVm, long size, NetworkCloudlet senderCloudlet, NetworkCloudlet receiverCloudlet) {
        this.source = sourceVm;
        this.destination = destinationVm;
        this.size = size;
        this.receiverCloudlet = receiverCloudlet;
        this.senderCloudlet = senderCloudlet;
    }

    public NetworkHost getDestinationHost() {
        return this.destination.getHost();
    }

    @Override
    @NonNull
    public final NetworkVm getSource() {
        return this.source;
    }

    @Override
    @NonNull
    public final NetworkVm getDestination() {
        return this.destination;
    }

    @NonNull
    public final NetworkCloudlet getSenderCloudlet() {
        return this.senderCloudlet;
    }

    @NonNull
    public final NetworkCloudlet getReceiverCloudlet() {
        return this.receiverCloudlet;
    }

    @Override
    public final long getSize() {
        return this.size;
    }

    @Override
    public final double getSendTime() {
        return this.sendTime;
    }

    @Override
    public final double getReceiveTime() {
        return this.receiveTime;
    }

    public final VmPacket setSource(@NonNull NetworkVm source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        this.source = source;
        return this;
    }

    public final VmPacket setDestination(@NonNull NetworkVm destination) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        this.destination = destination;
        return this;
    }

    @Override
    public final VmPacket setSendTime(double sendTime) {
        this.sendTime = sendTime;
        return this;
    }

    @Override
    public final VmPacket setReceiveTime(double receiveTime) {
        this.receiveTime = receiveTime;
        return this;
    }
}

