/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.network;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.core.SimEntity;
import org.cloudsimplus.network.NetworkPacket;
import org.cloudsimplus.util.MathUtil;

public class IcmpPacket
implements NetworkPacket<SimEntity> {
    private static final int UNSET_BAUD_RATE = -1;
    private CloudSimTag tag;
    private final String name;
    private long size;
    private final int packetId;
    private SimEntity source;
    private SimEntity destination;
    @NonNull
    private SimEntity lastHop;
    private int netServiceLevel;
    private double baudRate;
    private final List<Double> baudRateList;
    private final List<SimEntity> entities;
    private final List<Double> entryTimes;
    private final List<Double> exitTimes;
    private final DecimalFormat num;
    private double sendTime;
    private double receiveTime;

    public IcmpPacket(String name, int packetID, long size, SimEntity source, SimEntity destination, int netServiceLevel) {
        this.name = name;
        this.packetId = packetID;
        this.source = source;
        this.destination = destination;
        this.size = size;
        this.netServiceLevel = netServiceLevel;
        this.entities = new ArrayList<SimEntity>();
        this.entryTimes = new ArrayList<Double>();
        this.exitTimes = new ArrayList<Double>();
        this.baudRateList = new ArrayList<Double>();
        this.baudRate = -1.0;
        this.lastHop = this.source;
        this.tag = CloudSimTag.ICMP_PKT_SUBMIT;
        this.num = new DecimalFormat("#0.000#");
    }

    public int getId() {
        return this.packetId;
    }

    public String toString() {
        if (this.name == null) {
            return "Empty IcmpPacket that contains no ping information.";
        }
        int SIZE = 1000;
        StringBuilder sb = new StringBuilder(1000);
        sb.append("Ping information for ").append(this.name).append("%nEntity Name\tEntry Time\tExit Time\t Bandwidth%n".formatted(new Object[0])).append("----------------------------------------------------------").append(System.lineSeparator());
        String tab = "    ";
        for (int i = 0; i < this.entities.size(); ++i) {
            long resID = this.entities.get(i).getId();
            String entry = this.getData(this.entryTimes, i);
            String exit = this.getData(this.exitTimes, i);
            String bandwidth = this.getData(this.baudRateList, i);
            sb.append("Entity ").append(resID).append("\t\t").append("%s%s%s%s%s%s%s%n".formatted(entry, "    ", "    ", exit, "    ", "    ", bandwidth));
        }
        sb.append(System.lineSeparator()).append("Round Trip Time : ").append(this.num.format(this.getTotalResponseTime())).append(" seconds%nNumber of Hops  : ".formatted(new Object[0])).append(this.getNumberOfHops()).append(System.lineSeparator()).append("Bottleneck Bandwidth : ").append(this.baudRate).append(" bits/s");
        return sb.toString();
    }

    private String getData(List<Double> dataList, int index) {
        try {
            double id = dataList.get(index);
            return this.num.format(id);
        }
        catch (Exception e) {
            return "    N/A";
        }
    }

    public void setSize(long size) {
        this.size = MathUtil.nonNegative(size, "size");
    }

    public int getNumberOfHops() {
        int PAIR = 2;
        return (this.entities.size() - 2 + 1) / 2;
    }

    public double getTotalResponseTime() {
        try {
            double startTime = this.exitTimes.stream().findFirst().orElse(0.0);
            double receiveTime = this.entryTimes.stream().findFirst().orElse(0.0);
            return receiveTime - startTime;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public void addHop(SimEntity entity) {
        this.entities.add(entity);
    }

    public void addEntryTime(double time) {
        this.entryTimes.add(Math.min(time, 0.0));
    }

    public void addExitTime(double time) {
        this.exitTimes.add(Math.min(time, 0.0));
    }

    public void addBaudRate(double baudRate) {
        this.baudRateList.add(baudRate);
        if (this.baudRate <= -1.0 || this.baudRate > baudRate) {
            this.baudRate = baudRate;
        }
    }

    public List<Double> getDetailBaudRate() {
        return Collections.unmodifiableList(this.baudRateList);
    }

    public List<SimEntity> getHopsList() {
        return Collections.unmodifiableList(this.entities);
    }

    public List<Double> getDetailEntryTimes() {
        return Collections.unmodifiableList(this.entryTimes);
    }

    public List<Double> getDetailExitTimes() {
        return Collections.unmodifiableList(this.exitTimes);
    }

    public void setTag(CloudSimTag tag) {
        if (tag.between(CloudSimTag.ICMP_PKT_SUBMIT, CloudSimTag.ICMP_PKT_RETURN)) {
            this.tag = tag;
            return;
        }
        String fmt = "Tag must be between %s and %s";
        String msg = "Tag must be between %s and %s".formatted(CloudSimTag.ICMP_PKT_SUBMIT, CloudSimTag.ICMP_PKT_RETURN);
        throw new IllegalArgumentException(msg);
    }

    public final CloudSimTag getTag() {
        return this.tag;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public final long getSize() {
        return this.size;
    }

    public final int getPacketId() {
        return this.packetId;
    }

    @Override
    public final SimEntity getSource() {
        return this.source;
    }

    @Override
    public final SimEntity getDestination() {
        return this.destination;
    }

    @NonNull
    public final SimEntity getLastHop() {
        return this.lastHop;
    }

    public final int getNetServiceLevel() {
        return this.netServiceLevel;
    }

    public final double getBaudRate() {
        return this.baudRate;
    }

    public final List<Double> getBaudRateList() {
        return this.baudRateList;
    }

    public final List<SimEntity> getEntities() {
        return this.entities;
    }

    public final List<Double> getEntryTimes() {
        return this.entryTimes;
    }

    public final List<Double> getExitTimes() {
        return this.exitTimes;
    }

    @Override
    public final double getSendTime() {
        return this.sendTime;
    }

    @Override
    public final double getReceiveTime() {
        return this.receiveTime;
    }

    public final IcmpPacket setSource(SimEntity source) {
        this.source = source;
        return this;
    }

    public final IcmpPacket setDestination(SimEntity destination) {
        this.destination = destination;
        return this;
    }

    public final IcmpPacket setLastHop(@NonNull SimEntity lastHop) {
        if (lastHop == null) {
            throw new NullPointerException("lastHop is marked non-null but is null");
        }
        this.lastHop = lastHop;
        return this;
    }

    public final IcmpPacket setNetServiceLevel(int netServiceLevel) {
        this.netServiceLevel = netServiceLevel;
        return this;
    }

    public final IcmpPacket setBaudRate(double baudRate) {
        this.baudRate = baudRate;
        return this;
    }

    @Override
    public final IcmpPacket setSendTime(double sendTime) {
        this.sendTime = sendTime;
        return this;
    }

    @Override
    public final IcmpPacket setReceiveTime(double receiveTime) {
        this.receiveTime = receiveTime;
        return this;
    }
}

