/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.network;

import lombok.NonNull;
import org.cloudsimplus.hosts.network.NetworkHost;
import org.cloudsimplus.network.NetworkPacket;
import org.cloudsimplus.network.VmPacket;
import org.cloudsimplus.network.switches.EdgeSwitch;

public final class HostPacket
implements NetworkPacket<NetworkHost> {
    private final VmPacket vmPacket;
    private NetworkHost source;
    private NetworkHost destination;
    private double sendTime;
    private double receiveTime;

    public HostPacket(NetworkHost sourceHost, @NonNull VmPacket vmPacket) {
        if (vmPacket == null) {
            throw new NullPointerException("vmPacket is marked non-null but is null");
        }
        this.vmPacket = vmPacket;
        this.sendTime = vmPacket.getSendTime();
        this.setSource(sourceHost);
    }

    @Override
    public long getSize() {
        return this.vmPacket.getSize();
    }

    public EdgeSwitch getVmEdgeSwitch() {
        return this.vmPacket.getDestinationHost().getEdgeSwitch();
    }

    public final VmPacket getVmPacket() {
        return this.vmPacket;
    }

    @Override
    public final NetworkHost getSource() {
        return this.source;
    }

    @Override
    public final NetworkHost getDestination() {
        return this.destination;
    }

    @Override
    public final double getSendTime() {
        return this.sendTime;
    }

    @Override
    public final double getReceiveTime() {
        return this.receiveTime;
    }

    public final HostPacket setSource(NetworkHost source) {
        this.source = source;
        return this;
    }

    public final HostPacket setDestination(NetworkHost destination) {
        this.destination = destination;
        return this;
    }

    @Override
    public final HostPacket setSendTime(double sendTime) {
        this.sendTime = sendTime;
        return this;
    }

    @Override
    public final HostPacket setReceiveTime(double receiveTime) {
        this.receiveTime = receiveTime;
        return this;
    }
}

