/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.listeners;

import lombok.NonNull;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.hosts.HostSuitability;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.VmDatacenterEventInfo;
import org.cloudsimplus.vms.Vm;

public final class DatacenterVmMigrationEventInfo
implements VmDatacenterEventInfo {
    private final Vm vm;
    private final double time;
    private final HostSuitability suitability;
    private final EventListener<DatacenterVmMigrationEventInfo> listener;

    private DatacenterVmMigrationEventInfo(@NonNull Vm vm, @NonNull HostSuitability suitability, @NonNull EventListener<DatacenterVmMigrationEventInfo> listener) {
        if (vm == null) {
            throw new NullPointerException("vm is marked non-null but is null");
        }
        if (suitability == null) {
            throw new NullPointerException("suitability is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.vm = vm;
        this.time = vm.getSimulation().clock();
        this.suitability = suitability;
        this.listener = listener;
    }

    @Override
    public Datacenter getDatacenter() {
        return this.vm.getHost().getDatacenter();
    }

    public boolean isMigrationSuccessful() {
        return this.suitability.fully();
    }

    public static DatacenterVmMigrationEventInfo of(EventListener<DatacenterVmMigrationEventInfo> listener, Vm vm, HostSuitability suitability) {
        return new DatacenterVmMigrationEventInfo(vm, suitability, listener);
    }

    @Override
    public final Vm getVm() {
        return this.vm;
    }

    @Override
    public final double getTime() {
        return this.time;
    }

    public final HostSuitability getSuitability() {
        return this.suitability;
    }

    public final EventListener<DatacenterVmMigrationEventInfo> getListener() {
        return this.listener;
    }
}

