/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.hosts.network;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.hosts.HostSimple;
import org.cloudsimplus.hosts.HostSuitability;
import org.cloudsimplus.network.HostPacket;
import org.cloudsimplus.network.VmPacket;
import org.cloudsimplus.network.switches.EdgeSwitch;
import org.cloudsimplus.resources.Pe;
import org.cloudsimplus.schedulers.cloudlet.CloudletScheduler;
import org.cloudsimplus.schedulers.cloudlet.network.CloudletTaskScheduler;
import org.cloudsimplus.schedulers.cloudlet.network.CloudletTaskSchedulerSimple;
import org.cloudsimplus.vms.Vm;
import org.cloudsimplus.vms.network.NetworkVm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkHost
extends HostSimple {
    public static final NetworkHost NULL = new NetworkHost();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)NetworkHost.class.getSimpleName());
    private int totalDataTransferBytes;
    private final List<HostPacket> pktsToSendForLocalVms;
    private final List<HostPacket> pktsToSendForExternalVms;
    private final List<HostPacket> hostPktsReceived = new ArrayList<HostPacket>();
    @NonNull
    private EdgeSwitch edgeSwitch;

    public NetworkHost(long ram, long bw, long storage, List<Pe> peList) {
        super(ram, bw, storage, peList);
        this.pktsToSendForExternalVms = new ArrayList<HostPacket>();
        this.pktsToSendForLocalVms = new ArrayList<HostPacket>();
    }

    private NetworkHost() {
        this(0L, 0L, 0L, List.of(Pe.NULL));
        this.setId(-1L);
    }

    @Override
    public double updateProcessing(double currentTime) {
        double nextFinishingCloudletTime = super.updateProcessing(currentTime);
        this.receivePackets();
        this.sendAllPacketListsOfAllVms();
        return nextFinishingCloudletTime;
    }

    private void receivePackets() {
        for (HostPacket hostPkt : this.hostPktsReceived) {
            this.receivePacket(hostPkt.getVmPacket());
        }
        this.hostPktsReceived.clear();
    }

    private void receivePacket(VmPacket vmPacket) {
        Vm destinationVm = this.receiveVmPacket(vmPacket);
        if (this.getVmList().contains(destinationVm)) {
            CloudletTaskScheduler taskScheduler = this.getVmPacketScheduler(destinationVm);
            taskScheduler.addPacketToListOfPacketsSentFromVm(vmPacket);
            LOGGER.trace("{}: {}: {} received pkt with {} bytes from {} in {} and forwarded it to {} in {}", new Object[]{this.getSimulation().clockStr(), this.getClass().getSimpleName(), this, vmPacket.getSize(), vmPacket.getSenderCloudlet(), vmPacket.getSource(), vmPacket.getReceiverCloudlet(), vmPacket.getDestination()});
            return;
        }
        LOGGER.warn("{}: {}: Destination {} was not found inside {}", new Object[]{this.getSimulation().clockStr(), this.getClass(), vmPacket.getDestination(), this});
    }

    private Vm receiveVmPacket(VmPacket vmPacket) {
        vmPacket.setReceiveTime(this.getSimulation().clock());
        return vmPacket.getDestination();
    }

    private void sendAllPacketListsOfAllVms() {
        this.getVmList().forEach(this::collectAllPacketsToSendFromVm);
        this.sendPacketsToLocalVms();
        this.sendPacketsToExternalVms();
    }

    private void sendPacketsToLocalVms() {
        for (HostPacket hostPkt : this.pktsToSendForLocalVms) {
            hostPkt.setSendTime(hostPkt.getReceiveTime());
            Vm destinationVm = this.receiveVmPacket(hostPkt.getVmPacket());
            this.getVmPacketScheduler(destinationVm).addPacketToListOfPacketsSentFromVm(hostPkt.getVmPacket());
        }
        if (!this.pktsToSendForLocalVms.isEmpty()) {
            for (Vm vm : this.getVmList()) {
                vm.updateProcessing(this.getVmScheduler().getAllocatedMips(vm));
            }
        }
        this.pktsToSendForLocalVms.clear();
    }

    private void sendPacketsToExternalVms() {
        for (HostPacket pkt : this.pktsToSendForExternalVms) {
            double delay = this.edgeSwitch.downlinkTransferDelay(pkt, this.pktsToSendForExternalVms.size());
            this.totalDataTransferBytes = (int)((long)this.totalDataTransferBytes + pkt.getSize());
            this.getSimulation().send(this.getDatacenter(), this.getEdgeSwitch(), delay, CloudSimTag.NETWORK_EVENT_UP, pkt);
        }
        this.pktsToSendForExternalVms.clear();
    }

    private CloudletTaskScheduler getVmPacketScheduler(Vm vm) {
        return vm.getCloudletScheduler().getTaskScheduler();
    }

    @Override
    public HostSuitability createVm(Vm vm) {
        HostSuitability suitability = super.createVm(vm);
        this.setPacketScheduler(vm);
        return suitability;
    }

    private void setPacketScheduler(Vm vm) {
        CloudletScheduler scheduler = vm.getCloudletScheduler();
        if (!scheduler.isThereTaskScheduler()) {
            scheduler.setTaskScheduler(new CloudletTaskSchedulerSimple());
        }
    }

    private void collectAllPacketsToSendFromVm(Vm sourceVm) {
        CloudletTaskScheduler taskScheduler = this.getVmPacketScheduler(sourceVm);
        for (VmPacket vmPkt : taskScheduler.getVmPacketsToSend()) {
            this.collectPacketToSendFromVm(vmPkt);
        }
        taskScheduler.clearVmPacketsToSend();
    }

    private void collectPacketToSendFromVm(VmPacket vmPkt) {
        HostPacket hostPkt = new HostPacket(this, vmPkt);
        NetworkVm receiverVm = vmPkt.getDestination();
        List<HostPacket> pktsToSendList = this.getVmList().contains(receiverVm) ? this.pktsToSendForLocalVms : this.pktsToSendForExternalVms;
        pktsToSendList.add(hostPkt);
    }

    public void addReceivedNetworkPacket(HostPacket hostPacket) {
        this.hostPktsReceived.add(hostPacket);
    }

    public final int getTotalDataTransferBytes() {
        return this.totalDataTransferBytes;
    }

    @NonNull
    public final EdgeSwitch getEdgeSwitch() {
        return this.edgeSwitch;
    }

    public final NetworkHost setEdgeSwitch(@NonNull EdgeSwitch edgeSwitch) {
        if (edgeSwitch == null) {
            throw new NullPointerException("edgeSwitch is marked non-null but is null");
        }
        this.edgeSwitch = edgeSwitch;
        return this;
    }
}

