/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.hosts;

import java.util.Objects;

public final class HostSuitability {
    public static final HostSuitability NULL = new HostSuitability();
    private boolean forStorage;
    private boolean forRam;
    private boolean forBw;
    private boolean forPes;
    private String reason;

    public HostSuitability() {
    }

    public HostSuitability(String reason) {
        this.reason = Objects.requireNonNull(reason);
    }

    public void setSuitability(HostSuitability other) {
        this.forPes &= other.forPes;
        this.forRam &= other.forRam;
        this.forBw &= other.forBw;
        this.forStorage &= other.forStorage;
    }

    public boolean forStorage() {
        return this.forStorage;
    }

    public boolean forRam() {
        return this.forRam;
    }

    public boolean forBw() {
        return this.forBw;
    }

    public boolean forPes() {
        return this.forPes;
    }

    public boolean fully() {
        return this.forStorage && this.forRam && this.forBw && this.forPes;
    }

    public String toString() {
        if (this.fully()) {
            return "Host is fully suitable for the last requested VM";
        }
        if (this.reason != null) {
            return this.reason;
        }
        StringBuilder builder = new StringBuilder("lack of");
        if (!this.forPes) {
            builder.append(" PEs,");
        }
        if (!this.forRam) {
            builder.append(" RAM,");
        }
        if (!this.forStorage) {
            builder.append(" Storage,");
        }
        if (!this.forBw) {
            builder.append(" BW,");
        }
        return builder.substring(0, builder.length() - 1);
    }

    public final HostSuitability setForStorage(boolean forStorage) {
        this.forStorage = forStorage;
        return this;
    }

    public final HostSuitability setForRam(boolean forRam) {
        this.forRam = forRam;
        return this;
    }

    public final HostSuitability setForBw(boolean forBw) {
        this.forBw = forBw;
        return this;
    }

    public final HostSuitability setForPes(boolean forPes) {
        this.forPes = forPes;
        return this;
    }
}

