/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.hosts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.cloudsimplus.core.AbstractMachine;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.core.ResourceStatsComputer;
import org.cloudsimplus.core.Simulation;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.datacenters.DatacenterSimple;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.hosts.HostStateHistoryEntry;
import org.cloudsimplus.hosts.HostSuitability;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.HostEventInfo;
import org.cloudsimplus.listeners.HostUpdatesVmsProcessingEventInfo;
import org.cloudsimplus.power.PowerAware;
import org.cloudsimplus.power.models.PowerModelHost;
import org.cloudsimplus.provisioners.PeProvisioner;
import org.cloudsimplus.provisioners.ResourceProvisioner;
import org.cloudsimplus.provisioners.ResourceProvisionerSimple;
import org.cloudsimplus.resources.Bandwidth;
import org.cloudsimplus.resources.FileStorage;
import org.cloudsimplus.resources.HarddriveStorage;
import org.cloudsimplus.resources.Pe;
import org.cloudsimplus.resources.Ram;
import org.cloudsimplus.resources.Resource;
import org.cloudsimplus.resources.ResourceManageable;
import org.cloudsimplus.schedulers.MipsShare;
import org.cloudsimplus.schedulers.vm.VmScheduler;
import org.cloudsimplus.schedulers.vm.VmSchedulerSpaceShared;
import org.cloudsimplus.util.BytesConversion;
import org.cloudsimplus.util.MathUtil;
import org.cloudsimplus.util.TimeUtil;
import org.cloudsimplus.vms.HostResourceStats;
import org.cloudsimplus.vms.Vm;
import org.cloudsimplus.vms.VmGroup;
import org.cloudsimplus.vms.VmSimple;
import org.cloudsimplus.vms.VmStateHistoryEntry;

public class HostSimple
implements Host {
    private static long defaultRamCapacity = (long)BytesConversion.gigaToMega(10.0);
    private static long defaultBwCapacity = 1000L;
    private static long defaultStorageCapacity = (long)BytesConversion.gigaToMega(500.0);
    private long id;
    @NonNull
    private Simulation simulation;
    private Datacenter datacenter;
    private boolean activateOnDatacenterStartup;
    private PowerModelHost powerModel;
    private boolean failed;
    private boolean active;
    private boolean activationChangeInProgress;
    private double startTime = -1.0;
    private double firstStartTime = -1.0;
    private double shutdownTime;
    private double totalUpTime;
    private double lastBusyTime;
    private double idleShutdownDeadline;
    private final Ram ram;
    private final Bandwidth bw;
    private final HarddriveStorage disk;
    @NonNull
    private ResourceProvisioner ramProvisioner;
    @NonNull
    private ResourceProvisioner bwProvisioner;
    @NonNull
    private VmScheduler vmScheduler;
    @NonNull
    private List<Pe> peList;
    private final List<Vm> vmList = new ArrayList<Vm>();
    private HostResourceStats cpuUtilizationStats;
    private boolean stateHistoryEnabled;
    private final List<HostStateHistoryEntry> stateHistory;
    private final Set<Vm> vmsMigratingIn;
    private final Set<Vm> vmsMigratingOut;
    private final Set<EventListener<HostUpdatesVmsProcessingEventInfo>> onUpdateProcessingListeners;
    private final List<EventListener<HostEventInfo>> onStartupListeners;
    private final List<EventListener<HostEventInfo>> onShutdownListeners;
    private List<ResourceManageable> resources;
    private List<ResourceProvisioner> provisioners;
    private final List<Vm> vmCreatedList;
    private int freePesNumber;
    private int busyPesNumber;
    private int workingPesNumber;
    private int failedPesNumber;
    private boolean lazySuitabilityEvaluation;

    public HostSimple(List<Pe> peList) {
        this(peList, true);
    }

    public HostSimple(List<Pe> peList, boolean activate) {
        this(defaultRamCapacity, defaultBwCapacity, defaultStorageCapacity, peList, activate);
    }

    public HostSimple(ResourceProvisioner ramProvisioner, ResourceProvisioner bwProvisioner, long storage, List<Pe> peList) {
        this(ramProvisioner.getCapacity(), bwProvisioner.getCapacity(), storage, peList);
        this.setRamProvisioner(ramProvisioner);
        this.setBwProvisioner(bwProvisioner);
        this.setPeList(peList);
    }

    public HostSimple(long ram, long bw, long storage, List<Pe> peList) {
        this(ram, bw, new HarddriveStorage(storage), peList);
    }

    public HostSimple(long ram, long bw, HarddriveStorage storage, List<Pe> peList) {
        this(ram, bw, storage, peList, true);
    }

    public HostSimple(long ram, long bw, long storage, List<Pe> peList, boolean activate) {
        this(ram, bw, new HarddriveStorage(storage), peList, activate);
    }

    private HostSimple(long ram, long bw, @NonNull HarddriveStorage storage, List<Pe> peList, boolean activate) {
        if (storage == null) {
            throw new NullPointerException("storage is marked non-null but is null");
        }
        this.setId(-1L);
        this.setSimulation(Simulation.NULL);
        this.idleShutdownDeadline = -1.0;
        this.lazySuitabilityEvaluation = true;
        this.ram = new Ram(ram);
        this.bw = new Bandwidth(bw);
        this.disk = storage;
        this.setRamProvisioner(new ResourceProvisionerSimple());
        this.setBwProvisioner(new ResourceProvisionerSimple());
        this.setVmScheduler(new VmSchedulerSpaceShared());
        this.setPeList(peList);
        this.setFailed(false);
        this.shutdownTime = -1.0;
        this.setDatacenter(Datacenter.NULL);
        this.onUpdateProcessingListeners = new HashSet<EventListener<HostUpdatesVmsProcessingEventInfo>>();
        this.onStartupListeners = new ArrayList<EventListener<HostEventInfo>>();
        this.onShutdownListeners = new ArrayList<EventListener<HostEventInfo>>();
        this.cpuUtilizationStats = HostResourceStats.NULL;
        this.resources = new ArrayList<ResourceManageable>();
        this.vmCreatedList = new ArrayList<Vm>();
        this.provisioners = new ArrayList<ResourceProvisioner>();
        this.vmsMigratingIn = new HashSet<Vm>();
        this.vmsMigratingOut = new HashSet<Vm>();
        this.powerModel = PowerModelHost.NULL;
        this.stateHistory = new LinkedList<HostStateHistoryEntry>();
        this.activateOnDatacenterStartup = activate;
    }

    public static void setDefaultRamCapacity(long defaultCapacity) {
        AbstractMachine.validateCapacity(defaultCapacity);
        defaultRamCapacity = defaultCapacity;
    }

    public static void setDefaultBwCapacity(long defaultCapacity) {
        AbstractMachine.validateCapacity(defaultCapacity);
        defaultBwCapacity = defaultCapacity;
    }

    public static void setDefaultStorageCapacity(long defaultCapacity) {
        AbstractMachine.validateCapacity(defaultCapacity);
        defaultStorageCapacity = defaultCapacity;
    }

    @Override
    public double updateProcessing(double currentTime) {
        if (this.vmList.isEmpty() && this.isIdleEnough(this.idleShutdownDeadline)) {
            this.setActive(false);
        }
        double nextSimulationDelay = Double.MAX_VALUE;
        for (int i = 0; i < this.vmList.size(); ++i) {
            nextSimulationDelay = this.updateVmProcessing(this.vmList.get(i), currentTime, nextSimulationDelay);
        }
        this.notifyOnUpdateProcessingListeners(currentTime);
        this.cpuUtilizationStats.add(currentTime);
        this.addStateHistory(currentTime);
        if (!this.vmList.isEmpty()) {
            this.lastBusyTime = currentTime;
        }
        return nextSimulationDelay;
    }

    protected double updateVmProcessing(Vm vm, double currentTime, double nextSimulationDelay) {
        double delay = vm.updateProcessing(currentTime, this.vmScheduler.getAllocatedMips(vm));
        return delay > 0.0 ? Math.min(delay, nextSimulationDelay) : nextSimulationDelay;
    }

    private void notifyOnUpdateProcessingListeners(double nextSimulationTime) {
        this.onUpdateProcessingListeners.forEach(l -> l.update(HostUpdatesVmsProcessingEventInfo.of(l, (Host)this, nextSimulationTime)));
    }

    @Override
    public HostSuitability createVm(Vm vm) {
        HostSuitability suitability = this.createVmInternal(vm);
        if (suitability.fully()) {
            this.addVmToCreatedList(vm);
            vm.setHost(this);
            vm.setCreated(true);
            vm.setStartTime(this.getSimulation().clock());
        }
        return suitability;
    }

    @Override
    public HostSuitability createTemporaryVm(Vm vm) {
        return this.createVmInternal(vm);
    }

    private HostSuitability createVmInternal(Vm vm) {
        if (vm instanceof VmGroup) {
            return new HostSuitability("Just internal VMs inside a VmGroup can be created, not the VmGroup itself.");
        }
        HostSuitability suitability = this.allocateResourcesForVm(vm, false);
        if (suitability.fully()) {
            this.vmList.add(vm);
        }
        return suitability;
    }

    private HostSuitability allocateResourcesForVm(Vm vm, boolean inMigration) {
        HostSuitability suitability = this.isSuitableForVm(vm, inMigration, true);
        if (!suitability.fully()) {
            return suitability;
        }
        if (inMigration) {
            this.vmsMigratingIn.add(vm);
        }
        vm.setInMigration(inMigration);
        this.allocateResourcesForVm(vm);
        return suitability;
    }

    private void allocateResourcesForVm(Vm vm) {
        this.ramProvisioner.allocateResourceForVm(vm, vm.getCurrentRequestedRam());
        this.bwProvisioner.allocateResourceForVm(vm, vm.getCurrentRequestedBw());
        this.disk.getStorage().allocateResource(vm.getStorage());
        this.vmScheduler.allocatePesForVm(vm, vm.getCurrentRequestedMips());
    }

    private void logAllocationError(boolean showFailureLog, Vm vm, boolean inMigration, String resourceUnit, Resource pmResource, Resource vmRequestedResource) {
        if (!showFailureLog) {
            return;
        }
        String migration = inMigration ? "VM Migration" : "VM Creation";
        String msg = pmResource.getAvailableResource() > 0L ? "just " + pmResource.getAvailableResource() + " " + resourceUnit : "no amount";
        LOGGER.error("{}: {}: [{}] Allocation of {} to {} failed due to lack of {}. Required {} but there is {} available.", new Object[]{this.simulation.clockStr(), this.getClass().getSimpleName(), migration, vm, this, pmResource.getClass().getSimpleName(), vmRequestedResource.getCapacity(), msg});
    }

    @Override
    public void reallocateMigratingInVms() {
        for (Vm vm : this.getVmsMigratingIn()) {
            if (!this.vmList.contains(vm)) {
                this.vmList.add(vm);
            }
            this.allocateResourcesForVm(vm);
        }
    }

    @Override
    public boolean isSuitableForVm(Vm vm) {
        return this.getSuitabilityFor(vm).fully();
    }

    private HostSuitability isSuitableForVm(Vm vm, boolean inMigration, boolean showFailureLog) {
        HostSuitability suitability = new HostSuitability();
        suitability.setForStorage(this.disk.isAmountAvailable(vm.getStorage()));
        if (!suitability.forStorage()) {
            this.logAllocationError(showFailureLog, vm, inMigration, "MB", this.getStorage(), vm.getStorage());
            if (this.lazySuitabilityEvaluation) {
                return suitability;
            }
        }
        suitability.setForRam(this.ramProvisioner.isSuitableForVm(vm, vm.getRam()));
        if (!suitability.forRam()) {
            this.logAllocationError(showFailureLog, vm, inMigration, "MB", this.getRam(), vm.getRam());
            if (this.lazySuitabilityEvaluation) {
                return suitability;
            }
        }
        suitability.setForBw(this.bwProvisioner.isSuitableForVm(vm, vm.getBw()));
        if (!suitability.forBw()) {
            this.logAllocationError(showFailureLog, vm, inMigration, "Mbps", this.getBw(), vm.getBw());
            if (this.lazySuitabilityEvaluation) {
                return suitability;
            }
        }
        suitability.setForPes(this.vmScheduler.isSuitableForVm(vm));
        return suitability;
    }

    @Override
    public HostSuitability getSuitabilityFor(Vm vm) {
        return this.isSuitableForVm(vm, false, false);
    }

    @Override
    public boolean hasEverStarted() {
        return this.firstStartTime > -1.0;
    }

    @Override
    public final Host setActive(boolean activate) {
        double delay;
        if (!activate) {
            this.activateOnDatacenterStartup = false;
        }
        double d = delay = activate ? this.powerModel.getStartupDelay() : this.powerModel.getShutDownDelay();
        if (this.active == activate || delay > 0.0 && this.activationChangeInProgress) {
            return this;
        }
        if (this.isFailed() && activate) {
            throw new IllegalStateException("The Host is failed and cannot be activated.");
        }
        if (delay == 0.0) {
            this.processActivation(activate);
            return this;
        }
        if (!this.simulation.isRunning()) {
            return this;
        }
        CloudSimTag tag = activate ? CloudSimTag.HOST_POWER_ON : CloudSimTag.HOST_POWER_OFF;
        String msg = (activate ? "on" : "off") + " (expected time: {} seconds).";
        LOGGER.info("{}: {} is being powered " + msg, new Object[]{this.getSimulation().clockStr(), this, delay});
        this.datacenter.schedule(delay, tag, this);
        this.activationChangeInProgress = true;
        return this;
    }

    public void processActivation(boolean activate) {
        boolean wasActive = this.active;
        if (activate) {
            this.setStartTime(this.getSimulation().clock());
            this.powerModel.addStartupTotals();
        } else {
            this.setShutdownTime(this.getSimulation().clock());
            this.powerModel.addShutDownTotals();
        }
        this.active = activate;
        ((DatacenterSimple)this.datacenter).updateActiveHostsNumber(this);
        this.activationChangeInProgress = false;
        this.notifyStartupOrShutdown(activate, wasActive);
    }

    private void notifyStartupOrShutdown(boolean activate, boolean wasActive) {
        if (Simulation.NULL.equals(this.simulation) || !this.simulation.isRunning()) {
            return;
        }
        if (activate && !wasActive) {
            LOGGER.info("{}: {} is powered on.", (Object)this.getSimulation().clockStr(), (Object)this);
            this.updateOnStartupListeners();
        } else if (!activate && wasActive) {
            String reason = this.isIdleEnough(this.idleShutdownDeadline) ? " after becoming idle" : "";
            LOGGER.info("{}: {} is powered off{}.", new Object[]{this.getSimulation().clockStr(), this, reason});
            this.updateOnShutdownListeners();
        }
    }

    private void updateOnShutdownListeners() {
        for (int i = 0; i < this.onShutdownListeners.size(); ++i) {
            EventListener<HostEventInfo> listener = this.onShutdownListeners.get(i);
            listener.update(HostEventInfo.of(listener, this, this.simulation.clock()));
        }
    }

    private void updateOnStartupListeners() {
        for (int i = 0; i < this.onStartupListeners.size(); ++i) {
            EventListener<HostEventInfo> listener = this.onStartupListeners.get(i);
            listener.update(HostEventInfo.of(listener, this, this.simulation.clock()));
        }
    }

    @Override
    public void destroyVm(Vm vm) {
        if (!vm.isCreated()) {
            return;
        }
        this.destroyVmInternal(vm);
        vm.setStopTime(this.getSimulation().clock());
        vm.notifyOnHostDeallocationListeners(this);
    }

    @Override
    public void destroyTemporaryVm(Vm vm) {
        this.destroyVmInternal(vm);
    }

    private void destroyVmInternal(Vm vm) {
        this.deallocateResourcesOfVm(Objects.requireNonNull(vm));
        this.vmList.remove(vm);
        vm.getBroker().getVmExecList().remove(vm);
    }

    protected void deallocateResourcesOfVm(Vm vm) {
        vm.setCreated(false);
        this.ramProvisioner.deallocateResourceForVm(vm);
        this.bwProvisioner.deallocateResourceForVm(vm);
        this.vmScheduler.deallocatePesFromVm(vm);
        this.disk.getStorage().deallocateResource(vm.getStorage());
    }

    @Override
    public void destroyAllVms() {
        PeProvisioner peProvisioner = this.getPeList().get(0).getPeProvisioner();
        for (Vm vm : this.vmList) {
            this.ramProvisioner.deallocateResourceForVm(vm);
            this.bwProvisioner.deallocateResourceForVm(vm);
            peProvisioner.deallocateResourceForVm(vm);
            vm.setCreated(false);
            this.disk.getStorage().deallocateResource(vm.getStorage());
        }
        this.vmList.clear();
    }

    @Override
    public Host addOnStartupListener(@NonNull EventListener<HostEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (EventListener.NULL.equals(listener)) {
            return this;
        }
        this.onStartupListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnStartupListener(@NonNull EventListener<HostEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return this.onStartupListeners.remove(listener);
    }

    @Override
    public Host addOnShutdownListener(@NonNull EventListener<HostEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (EventListener.NULL.equals(listener)) {
            return this;
        }
        this.onShutdownListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnShutdownListener(@NonNull EventListener<HostEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return this.onShutdownListeners.remove(listener);
    }

    @Override
    public boolean removeOnUpdateProcessingListener(@NonNull EventListener<HostUpdatesVmsProcessingEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return this.onUpdateProcessingListeners.remove(listener);
    }

    @Override
    public Host addOnUpdateProcessingListener(@NonNull EventListener<HostUpdatesVmsProcessingEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (EventListener.NULL.equals(listener)) {
            return this;
        }
        this.onUpdateProcessingListeners.add(listener);
        return this;
    }

    @Override
    public long getPesNumber() {
        return this.peList.size();
    }

    protected MipsShare getAllocatedMipsForVm(Vm vm) {
        return this.vmScheduler.getAllocatedMips(vm);
    }

    @Override
    public double getMips() {
        return this.peList.stream().mapToDouble(Pe::getCapacity).findFirst().orElse(0.0);
    }

    @Override
    public double getTotalMipsCapacity() {
        return this.peList.stream().filter(Pe::isWorking).mapToDouble(Pe::getCapacity).sum();
    }

    @Override
    public double getTotalAvailableMips() {
        return this.vmScheduler.getTotalAvailableMips();
    }

    @Override
    public double getTotalAllocatedMips() {
        return this.getTotalMipsCapacity() - this.getTotalAvailableMips();
    }

    @Override
    public double getTotalAllocatedMipsForVm(Vm vm) {
        return this.vmScheduler.getTotalAllocatedMipsForVm(vm);
    }

    @Override
    public Resource getBw() {
        return this.bwProvisioner.getPmResource();
    }

    @Override
    public Resource getRam() {
        return this.ramProvisioner.getPmResource();
    }

    @Override
    public FileStorage getStorage() {
        return this.disk;
    }

    @Override
    public final Host setRamProvisioner(ResourceProvisioner ramProvisioner) {
        this.checkSimulationIsRunningAndAttemptedToChangeHost("RAM");
        this.ramProvisioner = ramProvisioner;
        this.ramProvisioner.setResources(this.ram, vm -> ((VmSimple)vm).getRam());
        return this;
    }

    @Override
    public final Host setBwProvisioner(ResourceProvisioner bwProvisioner) {
        this.checkSimulationIsRunningAndAttemptedToChangeHost("BW");
        this.bwProvisioner = bwProvisioner;
        this.bwProvisioner.setResources(this.bw, vm -> ((VmSimple)vm).getBw());
        return this;
    }

    private void checkSimulationIsRunningAndAttemptedToChangeHost(String resourceName) {
        if (this.simulation.isRunning()) {
            String msg = "It is not allowed to change a Host's %s after the simulation started.";
            throw new IllegalStateException("It is not allowed to change a Host's %s after the simulation started.".formatted(resourceName));
        }
    }

    @Override
    public final Host setVmScheduler(VmScheduler vmScheduler) {
        this.vmScheduler = vmScheduler;
        vmScheduler.setHost(this);
        return this;
    }

    @Override
    public Host setStartTime(double startTime) {
        this.startTime = MathUtil.nonNegative(Math.floor(startTime), "startTime");
        if (this.firstStartTime == -1.0) {
            this.firstStartTime = this.startTime;
        }
        this.lastBusyTime = startTime;
        this.shutdownTime = -1.0;
        return this;
    }

    @Override
    public void setShutdownTime(double shutdownTime) {
        this.shutdownTime = MathUtil.nonNegative(Math.floor(shutdownTime), "shutdownTime");
        this.totalUpTime += this.getUpTime();
    }

    @Override
    public double getUpTime() {
        return this.active ? this.simulation.clock() - this.startTime : this.shutdownTime - this.startTime;
    }

    @Override
    public double getTotalUpTime() {
        return this.totalUpTime + (this.active ? this.getUpTime() : 0.0);
    }

    @Override
    public double getUpTimeHours() {
        return TimeUtil.secondsToHours(this.getUpTime());
    }

    @Override
    public double getTotalUpTimeHours() {
        return TimeUtil.secondsToHours(this.getTotalUpTime());
    }

    private void setPeList(List<Pe> peList) {
        if (peList.isEmpty()) {
            throw new IllegalArgumentException("The PE list for a Host cannot be empty");
        }
        this.checkSimulationIsRunningAndAttemptedToChangeHost("List of PE");
        this.peList = peList;
        long peId = Math.max(peList.get(peList.size() - 1).getId(), -1L);
        for (Pe pe : peList) {
            if (pe.getId() < 0L) {
                pe.setId(++peId);
            }
            pe.setStatus(Pe.Status.FREE);
        }
        this.failedPesNumber = 0;
        this.busyPesNumber = 0;
        this.workingPesNumber = this.freePesNumber = peList.size();
    }

    @Override
    public <T extends Vm> List<T> getVmList() {
        return this.vmList;
    }

    @Override
    public <T extends Vm> List<T> getVmCreatedList() {
        return Collections.unmodifiableList(this.vmCreatedList);
    }

    protected void addVmToList(@NonNull Vm vm) {
        if (vm == null) {
            throw new NullPointerException("vm is marked non-null but is null");
        }
        this.vmList.add(vm);
    }

    protected void addVmToCreatedList(@NonNull Vm vm) {
        if (vm == null) {
            throw new NullPointerException("vm is marked non-null but is null");
        }
        this.vmCreatedList.add(vm);
    }

    @Override
    public final boolean setFailed(boolean failed) {
        this.failed = failed;
        Pe.Status newStatus = failed ? Pe.Status.FAILED : Pe.Status.FREE;
        this.setPeStatus(this.peList, newStatus);
        if (failed && this.active) {
            this.active = false;
        }
        return true;
    }

    public final void setPeStatus(List<Pe> peList, Pe.Status newStatus) {
        for (Pe pe : peList) {
            this.updatePeStatus(pe, newStatus);
        }
    }

    private void updatePeStatus(Pe pe, Pe.Status newStatus) {
        if (pe.getStatus() != newStatus) {
            this.updatePeStatusCount(pe.getStatus(), false);
            this.updatePeStatusCount(newStatus, true);
            pe.setStatus(newStatus);
        }
    }

    private void updatePeStatusCount(Pe.Status status, boolean isIncrement) {
        int inc = isIncrement ? 1 : -1;
        switch (status) {
            case FAILED: {
                this.incFailedPesNumber(inc);
                break;
            }
            case FREE: {
                this.incFreePesNumber(inc);
                break;
            }
            case BUSY: {
                this.incBusyPesNumber(inc);
            }
        }
    }

    protected void incFailedPesNumber(int inc) {
        this.failedPesNumber += inc;
        this.workingPesNumber -= inc;
    }

    protected void incFreePesNumber(int inc) {
        this.freePesNumber += inc;
    }

    protected void incBusyPesNumber(int inc) {
        this.busyPesNumber += inc;
    }

    @Override
    public <T extends Vm> Set<T> getVmsMigratingIn() {
        return this.vmsMigratingIn;
    }

    @Override
    public boolean hasMigratingVms() {
        return !this.vmsMigratingIn.isEmpty() || !this.vmsMigratingOut.isEmpty();
    }

    @Override
    public boolean addMigratingInVm(Vm vm) {
        if (this.vmsMigratingIn.contains(vm)) {
            return false;
        }
        if (this.allocateResourcesForVm(vm, true).fully()) {
            ((VmSimple)vm).updateMigrationStartListeners(this);
            this.updateProcessing(this.simulation.clock());
            vm.getHost().updateProcessing(this.simulation.clock());
            return true;
        }
        return false;
    }

    @Override
    public void removeMigratingInVm(@NonNull Vm vm) {
        if (vm == null) {
            throw new NullPointerException("vm is marked non-null but is null");
        }
        this.vmsMigratingIn.remove(vm);
        this.vmList.remove(vm);
        vm.setInMigration(false);
    }

    @Override
    public Set<Vm> getVmsMigratingOut() {
        return Collections.unmodifiableSet(this.vmsMigratingOut);
    }

    @Override
    public boolean addVmMigratingOut(@NonNull Vm vm) {
        if (vm == null) {
            throw new NullPointerException("vm is marked non-null but is null");
        }
        return this.vmsMigratingOut.add(vm);
    }

    @Override
    public boolean removeVmMigratingOut(@NonNull Vm vm) {
        if (vm == null) {
            throw new NullPointerException("vm is marked non-null but is null");
        }
        return this.vmsMigratingOut.remove(vm);
    }

    @Override
    public final void setDatacenter(@NonNull Datacenter datacenter) {
        if (datacenter == null) {
            throw new NullPointerException("datacenter is marked non-null but is null");
        }
        if (!Datacenter.NULL.equals(this.datacenter)) {
            this.checkSimulationIsRunningAndAttemptedToChangeHost("Datacenter");
        }
        this.datacenter = datacenter;
    }

    public String toString() {
        String dc = this.datacenter == null || Datacenter.NULL.equals(this.datacenter) ? "" : "/DC %d".formatted(this.datacenter.getId());
        return "Host %d%s".formatted(this.getId(), dc);
    }

    @Override
    public long getAvailableStorage() {
        return this.disk.getAvailableResource();
    }

    @Override
    public double getBusyPesPercent() {
        return (double)this.getBusyPesNumber() / (double)this.getPesNumber();
    }

    @Override
    public double getBusyPesPercent(boolean hundredScale) {
        double scale = hundredScale ? 100.0 : 1.0;
        return this.getBusyPesPercent() * scale;
    }

    @Override
    public int compareTo(Host other) {
        if (this.equals(Objects.requireNonNull(other))) {
            return 0;
        }
        return Long.compare(this.id, other.getId());
    }

    @Override
    public List<ResourceManageable> getResources() {
        if (this.simulation.isRunning() && this.resources.isEmpty()) {
            this.resources = Arrays.asList(this.ram, this.bw);
        }
        return Collections.unmodifiableList(this.resources);
    }

    @Override
    public ResourceProvisioner getProvisioner(Class<? extends ResourceManageable> resourceClass) {
        if (this.simulation.isRunning() && this.provisioners.isEmpty()) {
            this.provisioners = Arrays.asList(this.ramProvisioner, this.bwProvisioner);
        }
        return this.provisioners.stream().filter(provisioner -> provisioner.getPmResource().isSubClassOf(resourceClass)).findFirst().orElse(ResourceProvisioner.NULL);
    }

    @Override
    public List<Pe> getWorkingPeList() {
        return this.getFilteredPeList(Pe::isWorking);
    }

    @Override
    public List<Pe> getBusyPeList() {
        return this.getFilteredPeList(Pe::isBusy);
    }

    @Override
    public List<Pe> getFreePeList() {
        return this.getFilteredPeList(Pe::isFree);
    }

    private List<Pe> getFilteredPeList(Predicate<Pe> status) {
        return this.peList.stream().filter(status).collect(Collectors.toList());
    }

    @Override
    public double getCpuPercentUtilization() {
        return this.computeCpuUtilizationPercent(this.getCpuMipsUtilization());
    }

    @Override
    public double getCpuPercentRequested() {
        return this.computeCpuUtilizationPercent(this.getCpuMipsRequested());
    }

    private double computeCpuUtilizationPercent(double mipsUsage) {
        double totalMips = this.getTotalMipsCapacity();
        if (totalMips == 0.0) {
            return 0.0;
        }
        double utilization = mipsUsage / totalMips;
        return utilization > 1.0 && utilization < 1.01 ? 1.0 : utilization;
    }

    @Override
    public double getCpuMipsUtilization() {
        return this.vmList.stream().mapToDouble(Vm::getTotalCpuMipsUtilization).sum();
    }

    private double getCpuMipsRequested() {
        return this.vmList.stream().mapToDouble(Vm::getTotalCpuMipsRequested).sum();
    }

    @Override
    public long getRamUtilization() {
        return this.ramProvisioner.getTotalAllocatedResource();
    }

    @Override
    public long getBwUtilization() {
        return this.bwProvisioner.getTotalAllocatedResource();
    }

    @Override
    public void enableUtilizationStats() {
        if (this.cpuUtilizationStats != null && this.cpuUtilizationStats != HostResourceStats.NULL) {
            return;
        }
        this.cpuUtilizationStats = new HostResourceStats(this, Host::getCpuPercentUtilization);
        if (this.vmList.isEmpty()) {
            String host = this.getId() > -1L ? this.toString() : "Host";
            LOGGER.info("Automatically enabling computation of utilization statistics for VMs on {} could not be performed because it doesn't have VMs yet. You need to enable it for each VM created.", (Object)host);
        } else {
            this.vmList.forEach(ResourceStatsComputer::enableUtilizationStats);
        }
    }

    @Override
    public final PowerAware<PowerModelHost> setPowerModel(PowerModelHost powerModel) {
        Objects.requireNonNull(powerModel, "powerModel cannot be null. You could provide a " + PowerModelHost.class.getSimpleName() + ".NULL instead.");
        if (powerModel.getHost() != null && powerModel.getHost() != NULL && !this.equals(powerModel.getHost())) {
            throw new IllegalStateException("The given PowerModel is already assigned to another Host. Each Host must have its own PowerModel instance.");
        }
        this.powerModel = powerModel;
        powerModel.setHost(this);
        return this;
    }

    @Override
    public List<Vm> getFinishedVms() {
        return this.getVmList().stream().filter(vm -> !vm.isInMigration()).filter(vm -> vm.getTotalCpuMipsRequested() == 0.0).collect(Collectors.toList());
    }

    private double addVmResourceUseToHistoryIfNotMigratingIn(Vm vm, double currentTime) {
        double totalAllocatedMips = this.getVmScheduler().getTotalAllocatedMipsForVm(vm);
        if (this.getVmsMigratingIn().contains(vm)) {
            LOGGER.info("{}: {}: {} is migrating in", new Object[]{this.getSimulation().clockStr(), this, vm});
            return totalAllocatedMips;
        }
        double totalRequestedMips = vm.getTotalCpuMipsRequested();
        if (totalAllocatedMips + 0.1 < totalRequestedMips) {
            String reason = this.getVmsMigratingOut().contains(vm) ? "migration overhead" : "capacity unavailability";
            long notAllocatedMipsByPe = (long)((totalRequestedMips - totalAllocatedMips) / (double)vm.getPesNumber());
            LOGGER.warn("{}: {}: {} MIPS not allocated for each one of the {} PEs from {} due to {}.", new Object[]{this.getSimulation().clockStr(), this, notAllocatedMipsByPe, vm.getPesNumber(), vm, reason});
        }
        VmStateHistoryEntry entry = new VmStateHistoryEntry(currentTime, totalAllocatedMips, totalRequestedMips, vm.isInMigration() && !this.getVmsMigratingIn().contains(vm));
        vm.addStateHistoryEntry(entry);
        if (vm.isInMigration()) {
            LOGGER.info("{}: {}: {} is migrating out ", new Object[]{this.getSimulation().clockStr(), this, vm});
            totalAllocatedMips /= this.getVmScheduler().getMaxCpuUsagePercentDuringOutMigration();
        }
        return totalAllocatedMips;
    }

    private void addStateHistory(double currentTime) {
        if (!this.stateHistoryEnabled) {
            return;
        }
        double hostTotalRequestedMips = 0.0;
        for (Vm vm : this.getVmList()) {
            double totalRequestedMips = vm.getTotalCpuMipsRequested();
            this.addVmResourceUseToHistoryIfNotMigratingIn(vm, currentTime);
            hostTotalRequestedMips += totalRequestedMips;
        }
        this.addStateHistoryEntry(currentTime, this.getCpuMipsUtilization(), hostTotalRequestedMips, this.active);
    }

    private void addStateHistoryEntry(double time, double allocatedMips, double requestedMips, boolean isActive) {
        HostStateHistoryEntry previousState;
        HostStateHistoryEntry newState = new HostStateHistoryEntry(time, allocatedMips, requestedMips, isActive);
        if (!this.stateHistory.isEmpty() && (previousState = this.stateHistory.get(this.stateHistory.size() - 1)).time() == time) {
            this.stateHistory.set(this.stateHistory.size() - 1, newState);
            return;
        }
        this.stateHistory.add(newState);
    }

    @Override
    public List<HostStateHistoryEntry> getStateHistory() {
        return Collections.unmodifiableList(this.stateHistory);
    }

    @Override
    public List<Vm> getMigratableVms() {
        return this.vmList.stream().filter(vm -> !vm.isInMigration()).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HostSimple)) {
            return false;
        }
        HostSimple other = (HostSimple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        Simulation this$simulation = this.getSimulation();
        Simulation other$simulation = other.getSimulation();
        return !(this$simulation == null ? other$simulation != null : !this$simulation.equals(other$simulation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HostSimple;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        Simulation $simulation = this.getSimulation();
        result = result * 59 + ($simulation == null ? 43 : $simulation.hashCode());
        return result;
    }

    public static long getDefaultRamCapacity() {
        return defaultRamCapacity;
    }

    public static long getDefaultBwCapacity() {
        return defaultBwCapacity;
    }

    public static long getDefaultStorageCapacity() {
        return defaultStorageCapacity;
    }

    @Override
    public final long getId() {
        return this.id;
    }

    @Override
    public final HostSimple setId(long id) {
        this.id = id;
        return this;
    }

    @Override
    @NonNull
    public final Simulation getSimulation() {
        return this.simulation;
    }

    @Override
    public final HostSimple setSimulation(@NonNull Simulation simulation) {
        if (simulation == null) {
            throw new NullPointerException("simulation is marked non-null but is null");
        }
        this.simulation = simulation;
        return this;
    }

    @Override
    public final Datacenter getDatacenter() {
        return this.datacenter;
    }

    public final boolean isActivateOnDatacenterStartup() {
        return this.activateOnDatacenterStartup;
    }

    @Override
    public final PowerModelHost getPowerModel() {
        return this.powerModel;
    }

    @Override
    public final boolean isFailed() {
        return this.failed;
    }

    @Override
    public final boolean isActive() {
        return this.active;
    }

    @Override
    public final double getStartTime() {
        return this.startTime;
    }

    @Override
    public final double getFirstStartTime() {
        return this.firstStartTime;
    }

    @Override
    public final double getShutdownTime() {
        return this.shutdownTime;
    }

    @Override
    public final double getLastBusyTime() {
        return this.lastBusyTime;
    }

    @Override
    public final double getIdleShutdownDeadline() {
        return this.idleShutdownDeadline;
    }

    @Override
    public final HostSimple setIdleShutdownDeadline(double idleShutdownDeadline) {
        this.idleShutdownDeadline = idleShutdownDeadline;
        return this;
    }

    @Override
    @NonNull
    public final ResourceProvisioner getRamProvisioner() {
        return this.ramProvisioner;
    }

    @Override
    @NonNull
    public final ResourceProvisioner getBwProvisioner() {
        return this.bwProvisioner;
    }

    @Override
    @NonNull
    public final VmScheduler getVmScheduler() {
        return this.vmScheduler;
    }

    @Override
    @NonNull
    public final List<Pe> getPeList() {
        return this.peList;
    }

    @Override
    public final HostResourceStats getCpuUtilizationStats() {
        return this.cpuUtilizationStats;
    }

    @Override
    public final boolean isStateHistoryEnabled() {
        return this.stateHistoryEnabled;
    }

    @Override
    public final HostSimple setStateHistoryEnabled(boolean stateHistoryEnabled) {
        this.stateHistoryEnabled = stateHistoryEnabled;
        return this;
    }

    @Override
    public final int getFreePesNumber() {
        return this.freePesNumber;
    }

    @Override
    public final int getBusyPesNumber() {
        return this.busyPesNumber;
    }

    @Override
    public final int getWorkingPesNumber() {
        return this.workingPesNumber;
    }

    @Override
    public final int getFailedPesNumber() {
        return this.failedPesNumber;
    }

    @Override
    public final boolean isLazySuitabilityEvaluation() {
        return this.lazySuitabilityEvaluation;
    }

    @Override
    public final HostSimple setLazySuitabilityEvaluation(boolean lazySuitabilityEvaluation) {
        this.lazySuitabilityEvaluation = lazySuitabilityEvaluation;
        return this;
    }
}

