/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.heuristics;

import org.cloudsimplus.distributions.ContinuousDistribution;
import org.cloudsimplus.heuristics.HeuristicAbstract;
import org.cloudsimplus.heuristics.HeuristicSolution;

public abstract class SimulatedAnnealingAbstract<S extends HeuristicSolution<?>>
extends HeuristicAbstract<S> {
    private double coldTemperature;
    private double currentTemperature;
    private double coolingRate;

    SimulatedAnnealingAbstract(ContinuousDistribution random, Class<S> solutionClass) {
        super(random, solutionClass);
    }

    @Override
    public double getAcceptanceProbability() {
        double boltzmannConstant = 1.0;
        return Math.exp((this.getBestSolutionSoFar().getCost() - this.getNeighborSolution().getCost()) / (1.0 * this.currentTemperature));
    }

    @Override
    public boolean isToStopSearch() {
        return this.currentTemperature <= this.coldTemperature;
    }

    @Override
    public void updateSystemState() {
        this.currentTemperature *= 1.0 - this.coolingRate;
        LOGGER.debug("{}: Best solution cost so far is {}, current system temperature is {}", new Object[]{System.currentTimeMillis(), this.getBestSolutionSoFar().getCost(), this.getCurrentTemperature()});
    }

    protected void setCurrentTemperature(double currentTemperature) {
        this.currentTemperature = currentTemperature;
    }

    public final double getColdTemperature() {
        return this.coldTemperature;
    }

    public final double getCurrentTemperature() {
        return this.currentTemperature;
    }

    public final double getCoolingRate() {
        return this.coolingRate;
    }

    public final SimulatedAnnealingAbstract<S> setColdTemperature(double coldTemperature) {
        this.coldTemperature = coldTemperature;
        return this;
    }

    public final SimulatedAnnealingAbstract<S> setCoolingRate(double coolingRate) {
        this.coolingRate = coolingRate;
        return this;
    }
}

