/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.heuristics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.heuristics.Heuristic;
import org.cloudsimplus.heuristics.HeuristicSolution;
import org.cloudsimplus.vms.Vm;

public class CloudletToVmMappingSolution
implements HeuristicSolution<Map<Cloudlet, Vm>> {
    public static final double MIN_DIFF = 1.0E-4;
    private final Map<Cloudlet, Vm> cloudletVmMap;
    private boolean recomputeCost = true;
    private double lastCost;
    private final Heuristic heuristic;

    public CloudletToVmMappingSolution(Heuristic heuristic) {
        this(heuristic, new HashMap<Cloudlet, Vm>());
    }

    private CloudletToVmMappingSolution(@NonNull Heuristic heuristic, @NonNull Map<Cloudlet, Vm> cloudletVmMap) {
        if (heuristic == null) {
            throw new NullPointerException("heuristic is marked non-null but is null");
        }
        if (cloudletVmMap == null) {
            throw new NullPointerException("cloudletVmMap is marked non-null but is null");
        }
        this.heuristic = heuristic;
        this.cloudletVmMap = cloudletVmMap;
    }

    public CloudletToVmMappingSolution(@NonNull CloudletToVmMappingSolution solution) {
        this(solution.heuristic, new HashMap<Cloudlet, Vm>(solution.cloudletVmMap));
        if (solution == null) {
            throw new NullPointerException("solution is marked non-null but is null");
        }
        this.recomputeCost = solution.recomputeCost;
        this.lastCost = solution.lastCost;
        this.cloudletVmMap.putAll(solution.cloudletVmMap);
    }

    public void bindCloudletToVm(@NonNull Cloudlet cloudlet, @NonNull Vm vm) {
        if (cloudlet == null) {
            throw new NullPointerException("cloudlet is marked non-null but is null");
        }
        if (vm == null) {
            throw new NullPointerException("vm is marked non-null but is null");
        }
        this.cloudletVmMap.put(cloudlet, vm);
        this.recomputeCost = true;
    }

    private void recomputeCostIfRequested() {
        if (this.recomputeCost) {
            this.lastCost = this.computeCostOfAllVms();
            this.recomputeCost = false;
        }
    }

    private double computeCostOfAllVms() {
        return this.groupCloudletsByVm().entrySet().stream().mapToDouble(this::getVmCost).sum();
    }

    private Map<Vm, List<Map.Entry<Cloudlet, Vm>>> groupCloudletsByVm() {
        return this.cloudletVmMap.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue));
    }

    @Override
    public double getCost() {
        this.recomputeCostIfRequested();
        return this.lastCost;
    }

    public double getCost(boolean forceRecompute) {
        this.recomputeCost |= forceRecompute;
        return this.getCost();
    }

    public double getVmCost(Map.Entry<Vm, List<Map.Entry<Cloudlet, Vm>>> entry) {
        Vm vm = entry.getKey();
        List<Cloudlet> cloudletList = this.convertMapEntryListToCloudletList(entry.getValue());
        return this.getVmCost(vm, cloudletList);
    }

    public double getVmCost(Vm vm, List<Cloudlet> cloudlets) {
        return Math.abs(vm.getPesNumber() - this.getTotalCloudletsPes(cloudlets));
    }

    private List<Cloudlet> convertMapEntryListToCloudletList(List<Map.Entry<Cloudlet, Vm>> entriesList) {
        return entriesList.stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private long getTotalCloudletsPes(List<Cloudlet> cloudletListForVm) {
        return cloudletListForVm.stream().mapToLong(Cloudlet::getPesNumber).sum();
    }

    @Override
    public int compareTo(@NonNull HeuristicSolution solution) {
        if (solution == null) {
            throw new NullPointerException("solution is marked non-null but is null");
        }
        double diff = this.getCost() - solution.getCost();
        if (Math.abs(diff) <= 1.0E-4) {
            return 0;
        }
        return diff > 0.0 ? -1 : 1;
    }

    @Override
    public Map<Cloudlet, Vm> getResult() {
        return Collections.unmodifiableMap(this.cloudletVmMap);
    }

    protected final boolean swapVmsOfTwoMapEntries(List<Map.Entry<Cloudlet, Vm>> entries) {
        if (entries == null || entries.size() != 2 || entries.get(0) == null || entries.get(1) == null) {
            return false;
        }
        Vm vm0 = entries.get(0).getValue();
        Vm vm1 = entries.get(1).getValue();
        entries.get(0).setValue(vm1);
        entries.get(1).setValue(vm0);
        return true;
    }

    boolean swapVmsOfTwoRandomSelectedMapEntries() {
        return this.swapVmsOfTwoMapEntries(this.getRandomMapEntries());
    }

    protected List<Map.Entry<Cloudlet, Vm>> getRandomMapEntries() {
        if (this.cloudletVmMap.isEmpty()) {
            return new ArrayList<Map.Entry<Cloudlet, Vm>>();
        }
        if (this.cloudletVmMap.size() == 1) {
            return this.createListWithFirstMapEntry();
        }
        return this.createListWithTwoRandomEntries();
    }

    private List<Map.Entry<Cloudlet, Vm>> createListWithFirstMapEntry() {
        return this.cloudletVmMap.entrySet().stream().limit(1L).collect(Collectors.toList());
    }

    private List<Map.Entry<Cloudlet, Vm>> createListWithTwoRandomEntries() {
        int size = this.cloudletVmMap.entrySet().size();
        int firstIdx = this.heuristic.getRandomValue(size);
        int secondIdx = this.heuristic.getRandomValue(size);
        ArrayList<Map.Entry<Cloudlet, Vm>> selected = new ArrayList<Map.Entry<Cloudlet, Vm>>(2);
        Iterator<Map.Entry<Cloudlet, Vm>> entryIterator = this.cloudletVmMap.entrySet().iterator();
        int i = 0;
        while (selected.size() < 2 && entryIterator.hasNext()) {
            Map.Entry<Cloudlet, Vm> solution = entryIterator.next();
            if (i == firstIdx || i == secondIdx) {
                selected.add(solution);
            }
            ++i;
        }
        return selected;
    }

    @Override
    public final Heuristic getHeuristic() {
        return this.heuristic;
    }
}

