/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.distributions;

import org.apache.commons.math3.distribution.WeibullDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.cloudsimplus.distributions.ContinuousDistribution;
import org.cloudsimplus.distributions.StatisticalDistribution;
import org.cloudsimplus.util.MathUtil;

public class WeibullDistr
extends WeibullDistribution
implements ContinuousDistribution {
    private static final long serialVersionUID = -4265866419607842138L;
    private boolean applyAntitheticVariates;
    private long seed;

    public WeibullDistr(double alpha, double beta) {
        this(alpha, beta, StatisticalDistribution.defaultSeed());
    }

    public WeibullDistr(double alpha, double beta, long seed) {
        this(alpha, beta, seed, StatisticalDistribution.newDefaultGen(seed));
    }

    public WeibullDistr(double alpha, double beta, long seed, RandomGenerator rng) {
        super(rng, alpha, beta);
        this.seed = MathUtil.nonNegative(seed, "Seed");
    }

    public void reseedRandomGenerator(long seed) {
        super.reseedRandomGenerator(seed);
        this.seed = seed;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public boolean isApplyAntitheticVariates() {
        return this.applyAntitheticVariates;
    }

    @Override
    public WeibullDistr setApplyAntitheticVariates(boolean applyAntitheticVariates) {
        this.applyAntitheticVariates = applyAntitheticVariates;
        return this;
    }

    @Override
    public double originalSample() {
        return super.sample();
    }
}

