/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.distributions;

import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.cloudsimplus.distributions.ContinuousDistribution;
import org.cloudsimplus.distributions.StatisticalDistribution;
import org.cloudsimplus.util.MathUtil;

public class ExponentialDistr
extends ExponentialDistribution
implements ContinuousDistribution {
    private static final long serialVersionUID = -7320841686232556798L;
    private boolean applyAntitheticVariates;
    private long seed;

    public ExponentialDistr(double mean) {
        this(mean, StatisticalDistribution.defaultSeed());
    }

    public ExponentialDistr(double mean, long seed) {
        this(mean, seed, StatisticalDistribution.newDefaultGen(seed));
    }

    public ExponentialDistr(double mean, long seed, RandomGenerator rng) {
        super(rng, mean);
        this.seed = MathUtil.nonNegative(seed, "Seed");
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    public void reseedRandomGenerator(long seed) {
        super.reseedRandomGenerator(seed);
        this.seed = seed;
    }

    @Override
    public boolean isApplyAntitheticVariates() {
        return this.applyAntitheticVariates;
    }

    @Override
    public ExponentialDistr setApplyAntitheticVariates(boolean applyAntitheticVariates) {
        this.applyAntitheticVariates = applyAntitheticVariates;
        return this;
    }

    @Override
    public double originalSample() {
        return super.sample();
    }
}

