/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.core;

import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;
import org.cloudsimplus.core.CircularTimeQueue;
import org.cloudsimplus.core.CloudSim;
import org.cloudsimplus.core.Simulation;
import org.cloudsimplus.core.events.SimEvent;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.listeners.EventListener;

public final class CloudSimPlus
extends CloudSim {
    private static final double DEF_MIN_TIME_BETWEEN_EVENTS = 0.1;
    private final CircularTimeQueue clockQueue;
    private final Set<EventListener<SimEvent>> onEventProcessingListeners = new HashSet<EventListener<SimEvent>>();
    private final Set<EventListener<EventInfo>> onSimulationPauseListeners = new HashSet<EventListener<EventInfo>>();
    private final Set<EventListener<EventInfo>> onClockTickListeners = new HashSet<EventListener<EventInfo>>();
    private final Set<EventListener<EventInfo>> onSimulationStartListeners = new HashSet<EventListener<EventInfo>>();

    public CloudSimPlus() {
        this(0.1);
    }

    public CloudSimPlus(double minTimeBetweenEvents) {
        super(minTimeBetweenEvents);
        this.clockQueue = new CircularTimeQueue(this);
    }

    @Override
    public double runFor(double interval) {
        double until;
        double d = until = interval == Double.MAX_VALUE ? interval : this.clock() + interval;
        if (!this.processEvents(until)) {
            this.setClock(until);
            if (this.noFutureEvents()) {
                this.finish();
            }
        }
        return this.clock();
    }

    @Override
    protected void processEvent(SimEvent evt) {
        super.processEvent(evt);
        for (EventListener<SimEvent> listener : this.onEventProcessingListeners) {
            listener.update(evt);
        }
    }

    @Override
    protected boolean doPause() {
        boolean wasPaused = super.doPause();
        if (wasPaused) {
            this.notifyEventListeners(this.onSimulationPauseListeners, this.clock());
        }
        return wasPaused;
    }

    @Override
    protected double setClock(double newTime) {
        double oldTime = super.setClock(newTime);
        this.clockQueue.tryToUpdateListeners(previousTime -> this.notifyEventListeners(this.onClockTickListeners, (double)previousTime));
        return oldTime;
    }

    private void notifyEventListeners(Set<EventListener<EventInfo>> listeners, double clock) {
        listeners.forEach(listener -> listener.update(EventInfo.of(listener, clock)));
    }

    @Override
    protected void notifyOnSimulationStartListeners() {
        if (!this.onSimulationStartListeners.isEmpty() && this.clock() > 0.0) {
            this.notifyEventListeners(this.onSimulationStartListeners, this.clock());
            this.onSimulationStartListeners.clear();
        }
    }

    @Override
    public Simulation addOnSimulationPauseListener(@NonNull EventListener<EventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.onSimulationPauseListeners.add(listener);
        return this;
    }

    @Override
    public Simulation addOnSimulationStartListener(@NonNull EventListener<EventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.onSimulationStartListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnSimulationPauseListener(@NonNull EventListener<EventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return this.onSimulationPauseListeners.remove(listener);
    }

    @Override
    public Simulation addOnEventProcessingListener(@NonNull EventListener<SimEvent> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.onEventProcessingListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnEventProcessingListener(@NonNull EventListener<SimEvent> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return this.onEventProcessingListeners.remove(listener);
    }

    @Override
    public Simulation addOnClockTickListener(@NonNull EventListener<EventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.onClockTickListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnClockTickListener(@NonNull EventListener<? extends EventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return this.onClockTickListeners.remove(listener);
    }
}

