/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.core;

import java.util.Objects;
import java.util.function.Predicate;
import lombok.NonNull;
import org.cloudsimplus.core.CloudSimPlus;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.core.SimEntity;
import org.cloudsimplus.core.Simulation;
import org.cloudsimplus.core.events.CloudSimEvent;
import org.cloudsimplus.core.events.SimEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CloudSimEntity
implements SimEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CloudSimEntity.class.getSimpleName());
    private long id;
    @NonNull
    private final Simulation simulation;
    private String name;
    private double startTime;
    private double shutdownTime;
    private SimEntity.State state;
    private SimEvent buffer;

    public CloudSimEntity(@NonNull Simulation simulation) {
        if (simulation == null) {
            throw new NullPointerException("simulation is marked non-null but is null");
        }
        this.simulation = simulation;
        this.setId(-1);
        this.state = SimEntity.State.RUNNABLE;
        this.simulation.addEntity(this);
        this.startTime = -1.0;
        this.shutdownTime = -1.0;
    }

    @Override
    public final boolean start() {
        if (this.isStarted()) {
            return false;
        }
        this.startInternal();
        this.startTime = this.simulation.clock();
        return true;
    }

    @Override
    public void shutdown() {
        if (this.state == SimEntity.State.FINISHED) {
            return;
        }
        this.setState(SimEntity.State.FINISHED);
        this.shutdownTime = this.simulation.clock();
        ((CloudSimPlus)this.simulation).removeFinishedEntity(this);
    }

    protected abstract void startInternal();

    @Override
    public boolean schedule(SimEntity dest, double delay, CloudSimTag tag, Object data) {
        return this.schedule(new CloudSimEvent(delay, this, dest, tag, data));
    }

    @Override
    public boolean schedule(double delay, CloudSimTag tag, Object data) {
        return this.schedule(this, delay, tag, data);
    }

    @Override
    public boolean schedule(double delay, CloudSimTag tag) {
        return this.schedule(this, delay, tag, null);
    }

    @Override
    public boolean schedule(SimEntity dest, double delay, CloudSimTag tag) {
        return this.schedule(dest, delay, tag, null);
    }

    @Override
    public boolean schedule(CloudSimTag tag, Object data) {
        return this.schedule(this, 0.0, tag, data);
    }

    @Override
    public boolean schedule(SimEvent evt) {
        if (this.canSendEvent(evt)) {
            this.simulation.send(evt);
            return true;
        }
        return false;
    }

    private boolean canSendEvent(SimEvent evt) {
        if (this.simulation.isRunning() || evt.getTag() == CloudSimTag.SIMULATION_END) {
            return true;
        }
        LOGGER.warn("{}: {}: Cannot send events before simulation starts or after it finishes. Trying to send message {} to {}", new Object[]{this.getSimulation().clockStr(), this, evt.getTag(), evt.getDestination()});
        return false;
    }

    public void scheduleNow(SimEntity dest, CloudSimTag tag, Object data) {
        this.schedule(dest, 0.0, tag, data);
    }

    public void scheduleNow(SimEntity dest, CloudSimTag tag) {
        this.schedule(dest, 0.0, tag, null);
    }

    public void scheduleFirstNow(SimEntity dest, CloudSimTag tag, Object data) {
        this.scheduleFirst(dest, 0.0, tag, data);
    }

    public void scheduleFirstNow(SimEntity dest, CloudSimTag tag) {
        this.scheduleFirst(dest, 0.0, tag, null);
    }

    public void scheduleFirst(SimEntity dest, double delay, CloudSimTag tag) {
        this.scheduleFirst(dest, delay, tag, null);
    }

    public void scheduleFirst(SimEntity dest, double delay, CloudSimTag tag, Object data) {
        CloudSimEvent evt = new CloudSimEvent(delay, this, dest, tag, data);
        if (this.canSendEvent(evt)) {
            this.simulation.sendFirst(evt);
        }
    }

    public void pause(double delay) {
        if (delay < 0.0) {
            throw new IllegalArgumentException("Negative delay supplied.");
        }
        if (this.simulation.isRunning()) {
            this.simulation.pauseEntity(this, delay);
        }
    }

    public SimEvent selectEvent(Predicate<SimEvent> predicate) {
        if (this.simulation.isRunning()) {
            return this.simulation.select(this, predicate);
        }
        return SimEvent.NULL;
    }

    public SimEvent cancelEvent(Predicate<SimEvent> predicate) {
        return this.simulation.isRunning() ? this.simulation.cancel(this, predicate) : SimEvent.NULL;
    }

    public SimEvent getNextEvent(Predicate<SimEvent> predicate) {
        if (this.simulation.isRunning()) {
            return this.selectEvent(predicate);
        }
        return SimEvent.NULL;
    }

    public SimEvent getNextEvent() {
        return this.getNextEvent(Simulation.ANY_EVT);
    }

    public void waitForEvent(Predicate<SimEvent> predicate) {
        if (this.simulation.isRunning()) {
            this.simulation.wait(this, predicate);
            this.state = SimEntity.State.WAITING;
        }
    }

    @Override
    public void run() {
        this.run(Double.MAX_VALUE);
    }

    public void run(double until) {
        SimEvent evt = Objects.requireNonNullElse(this.buffer, this.getNextEvent(e -> e.getTime() <= until));
        while (evt != SimEvent.NULL) {
            this.processEvent(evt);
            if (this.state != SimEntity.State.RUNNABLE) break;
            evt = this.getNextEvent(e -> e.getTime() <= until);
        }
        this.buffer = null;
    }

    @Override
    public SimEntity setName(@NonNull String name) throws IllegalArgumentException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (name.isBlank()) {
            throw new IllegalArgumentException("Entity names cannot be empty.");
        }
        this.name = name;
        return this;
    }

    protected final void setId(int id) {
        this.id = id;
        this.setAutomaticName();
    }

    private void setAutomaticName() {
        long id = this.id >= 0L ? this.id : (long)this.simulation.getNumEntities();
        this.name = "%s%d".formatted(this.getClass().getSimpleName(), id);
    }

    protected void setEventBuffer(@NonNull SimEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt is marked non-null but is null");
        }
        this.buffer = evt;
    }

    protected void send(SimEntity dest, double delay, CloudSimTag tag, Object data) {
        Objects.requireNonNull(dest);
        if (dest.getId() < 0L) {
            LOGGER.error("{}.send(): invalid entity id {} for {}", new Object[]{this.getName(), dest.getId(), dest});
            return;
        }
        if (delay < 0.0) {
            delay = 0.0;
        }
        if (Double.isInfinite(delay)) {
            throw new IllegalArgumentException("The specified delay is infinite value");
        }
        if (dest.getId() != this.getId()) {
            delay += this.getNetworkDelay(this, dest);
        }
        this.schedule(dest, delay, tag, data);
    }

    protected void send(SimEntity dest, double delay, CloudSimTag tag) {
        this.send(dest, delay, tag, null);
    }

    protected void sendNow(SimEntity dest, CloudSimTag tag, Object data) {
        this.send(dest, 0.0, tag, data);
    }

    protected void sendNow(SimEntity dest, CloudSimTag tag) {
        this.send(dest, 0.0, tag, null);
    }

    private double getNetworkDelay(SimEntity src, SimEntity dst) {
        return this.getSimulation().getNetworkTopology().getDelay(src, dst);
    }

    @Override
    public boolean isStarted() {
        return this.startTime > -1.0;
    }

    @Override
    public boolean isAlive() {
        return this.state != SimEntity.State.FINISHED;
    }

    @Override
    public boolean isFinished() {
        return this.state == SimEntity.State.FINISHED;
    }

    @Override
    public int compareTo(SimEntity entity) {
        return Long.compare(this.getId(), entity.getId());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudSimEntity)) {
            return false;
        }
        CloudSimEntity other = (CloudSimEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        Simulation this$simulation = this.getSimulation();
        Simulation other$simulation = other.getSimulation();
        return !(this$simulation == null ? other$simulation != null : !this$simulation.equals(other$simulation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CloudSimEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        Simulation $simulation = this.getSimulation();
        result = result * 59 + ($simulation == null ? 43 : $simulation.hashCode());
        return result;
    }

    @Override
    public final long getId() {
        return this.id;
    }

    @Override
    @NonNull
    public final Simulation getSimulation() {
        return this.simulation;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final double getStartTime() {
        return this.startTime;
    }

    @Override
    public final double getShutdownTime() {
        return this.shutdownTime;
    }

    @Override
    public final SimEntity.State getState() {
        return this.state;
    }

    @Override
    public final CloudSimEntity setState(SimEntity.State state) {
        this.state = state;
        return this;
    }
}

