/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cloudsimplus.core.CloudSim;
import org.cloudsimplus.core.CloudSimEntity;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.core.SimEntity;
import org.cloudsimplus.core.events.SimEvent;
import org.cloudsimplus.datacenters.Datacenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudInformationService
extends CloudSimEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CloudInformationService.class.getSimpleName());
    private final List<Datacenter> datacenterList = new ArrayList<Datacenter>();
    private final Set<CloudInformationService> cisList = new TreeSet<CloudInformationService>();

    CloudInformationService(CloudSim simulation) {
        super(simulation);
    }

    @Override
    protected void startInternal() {
    }

    @Override
    public void processEvent(SimEvent evt) {
        switch (evt.getTag()) {
            case REGISTER_REGIONAL_CIS: {
                this.cisList.add((CloudInformationService)evt.getData());
                break;
            }
            case REQUEST_REGIONAL_CIS: {
                super.send(evt.getSource(), 0.0, evt.getTag(), this.cisList);
                break;
            }
            case DC_REGISTRATION_REQUEST: {
                this.datacenterList.add((Datacenter)evt.getData());
                break;
            }
            case DC_LIST_REQUEST: {
                super.send(evt.getSource(), 0.0, evt.getTag(), this.datacenterList);
            }
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        LOGGER.info("{}: Notify all CloudSim Plus entities to shutdown.{}", (Object)super.getName(), (Object)System.lineSeparator());
        this.signalShutdown(this.datacenterList);
        this.signalShutdown(this.cisList);
        this.datacenterList.clear();
        this.cisList.clear();
    }

    private void signalShutdown(Collection<? extends SimEntity> list) {
        if (list == null) {
            return;
        }
        list.forEach(entity -> super.send((SimEntity)entity, 0.0, CloudSimTag.SIMULATION_END));
    }

    public final List<Datacenter> getDatacenterList() {
        return this.datacenterList;
    }
}

