/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.core;

import org.cloudsimplus.core.AbstractMachineNull;
import org.cloudsimplus.core.ChangeableId;
import org.cloudsimplus.core.Simulation;
import org.cloudsimplus.resources.Resource;
import org.cloudsimplus.resources.Resourceful;

public interface AbstractMachine<T extends Resource>
extends ChangeableId,
Resourceful {
    public static final AbstractMachine NULL = new AbstractMachineNull();

    public Resource getBw();

    public Resource getRam();

    public T getStorage();

    public long getPesNumber();

    public double getMips();

    public double getTotalMipsCapacity();

    public Simulation getSimulation();

    public double getStartTime();

    public AbstractMachine setStartTime(double var1);

    default public boolean isIdleEnough(double time) {
        if (time < 0.0) {
            return false;
        }
        return this.getIdleInterval() >= time;
    }

    default public double getIdleInterval() {
        return this.getSimulation().clock() - this.getLastBusyTime();
    }

    public double getLastBusyTime();

    default public boolean isIdle() {
        return this.getIdleInterval() > 0.0;
    }

    public static void validateCapacity(double capacity) {
        if (capacity <= 0.0) {
            throw new IllegalArgumentException("Capacity must be greater than zero");
        }
    }
}

