/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.cloudlets.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cloudsimplus.cloudlets.network.CloudletTask;
import org.cloudsimplus.cloudlets.network.NetworkCloudlet;
import org.cloudsimplus.network.VmPacket;

public class CloudletSendTask
extends CloudletTask {
    private final List<VmPacket> packetsToSend = new ArrayList<VmPacket>();

    public CloudletSendTask(int id) {
        super(id);
    }

    public VmPacket addPacket(NetworkCloudlet destinationCloudlet, long bytes) {
        if (this.getCloudlet() == null) {
            throw new IllegalStateException("You must assign a NetworkCloudlet to this Task before adding packets.");
        }
        if (!this.getCloudlet().isBoundToVm()) {
            throw new IllegalStateException("The source Cloudlet has to have an assigned VM.");
        }
        if (!destinationCloudlet.isBoundToVm()) {
            throw new IllegalStateException("The destination Cloudlet has to have an assigned VM.");
        }
        VmPacket packet = new VmPacket(this.getCloudlet().getVm(), destinationCloudlet.getVm(), bytes, this.getCloudlet(), destinationCloudlet);
        this.packetsToSend.add(packet);
        return packet;
    }

    public List<VmPacket> getPacketsToSend() {
        return Collections.unmodifiableList(this.packetsToSend);
    }

    public List<VmPacket> getPacketsToSend(double sendTime) {
        this.packetsToSend.forEach(pkt -> pkt.setSendTime(sendTime));
        if (this.isFinished()) {
            this.packetsToSend.clear();
        } else {
            this.setFinished(true);
        }
        return this.packetsToSend;
    }
}

