/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.cloudlets;

import java.util.List;
import org.cloudsimplus.brokers.DatacenterBroker;
import org.cloudsimplus.cloudlets.CloudletNull;
import org.cloudsimplus.core.CustomerEntity;
import org.cloudsimplus.core.UniquelyIdentifiable;
import org.cloudsimplus.listeners.CloudletVmEventInfo;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.resources.ResourceManageable;
import org.cloudsimplus.utilizationmodels.UtilizationModel;
import org.cloudsimplus.vms.Vm;

public interface Cloudlet
extends UniquelyIdentifiable,
Comparable<Cloudlet>,
CustomerEntity {
    public static final int NOT_ASSIGNED = -1;
    public static final Cloudlet NULL = new CloudletNull();

    public boolean addRequiredFile(String var1);

    public boolean addRequiredFiles(List<String> var1);

    public boolean deleteRequiredFile(String var1);

    public boolean hasRequiresFiles();

    public List<String> getRequiredFiles();

    public double getArrivalTime();

    public double getActualCpuTime();

    public long getFileSize();

    public long getOutputSize();

    public Status getStatus();

    @Override
    public double getSubmissionDelay();

    public boolean isReturnedToBroker();

    public double registerArrivalInDatacenter();

    public double getExecStartTime();

    public double getFinishTime();

    public long getJobId();

    public Cloudlet setJobId(long var1);

    public int getPriority();

    public Cloudlet setPriority(int var1);

    public int getNetServiceLevel();

    public long getPesNumber();

    public UtilizationModel getUtilizationModelBw();

    public UtilizationModel getUtilizationModelCpu();

    public UtilizationModel getUtilizationModelRam();

    public UtilizationModel getUtilizationModel(Class<? extends ResourceManageable> var1);

    public double getUtilizationOfCpu();

    public double getUtilizationOfCpu(double var1);

    public double getUtilizationOfRam();

    public double getUtilizationOfRam(double var1);

    public double getUtilizationOfBw();

    public double getUtilizationOfBw(double var1);

    public Vm getVm();

    public boolean isBoundToVm();

    public double getWaitingTime();

    public boolean isFinished();

    default public boolean isRunning() {
        return !this.isFinished();
    }

    public Cloudlet setFileSize(long var1);

    public Cloudlet setOutputSize(long var1);

    public Cloudlet setSizes(long var1);

    public boolean setStatus(Status var1);

    public Cloudlet setNetServiceLevel(int var1);

    public Cloudlet setPesNumber(long var1);

    public Cloudlet setUtilizationModel(UtilizationModel var1);

    public Cloudlet setUtilizationModelBw(UtilizationModel var1);

    public Cloudlet setUtilizationModelCpu(UtilizationModel var1);

    public Cloudlet setUtilizationModelRam(UtilizationModel var1);

    public Cloudlet setVm(Vm var1);

    public long getLength();

    public Cloudlet setLength(long var1);

    public long getTotalLength();

    public long getFinishedLengthSoFar();

    public boolean addFinishedLengthSoFar(long var1);

    public void setExecStartTime(double var1);

    public Cloudlet addOnStartListener(EventListener<CloudletVmEventInfo> var1);

    public boolean removeOnStartListener(EventListener<CloudletVmEventInfo> var1);

    public Cloudlet addOnUpdateProcessingListener(EventListener<CloudletVmEventInfo> var1);

    public boolean removeOnUpdateProcessingListener(EventListener<CloudletVmEventInfo> var1);

    public Cloudlet addOnFinishListener(EventListener<CloudletVmEventInfo> var1);

    public boolean removeOnFinishListener(EventListener<CloudletVmEventInfo> var1);

    public void notifyOnUpdateProcessingListeners(double var1);

    @Override
    public DatacenterBroker getBroker();

    @Override
    public CustomerEntity setBroker(DatacenterBroker var1);

    public Cloudlet reset();

    public Cloudlet setLifeTime(double var1);

    public double getLifeTime();

    public static enum Status {
        INSTANTIATED,
        READY,
        QUEUED,
        FROZEN,
        INEXEC,
        SUCCESS,
        FAILED,
        CANCELED,
        PAUSED,
        RESUMED,
        FAILED_RESOURCE_UNAVAILABLE;

    }
}

