/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import org.cloudsimplus.builders.tables.AbstractTableColumn;
import org.cloudsimplus.builders.tables.Table;

public class CsvTableColumn
extends AbstractTableColumn {
    public static final String DATA_COL_SEPARATOR_FORMAT = "%s%s";

    public CsvTableColumn(String title) {
        this(title, "");
    }

    public CsvTableColumn(String title, String subTitle) {
        this(title, subTitle, "");
    }

    public CsvTableColumn(Table table, String title, String subTitle) {
        super(table, title, subTitle);
    }

    public CsvTableColumn(Table table, String title) {
        super(table, title);
    }

    public CsvTableColumn(String title, String subTitle, String format) {
        super(title, subTitle, format);
    }

    @Override
    protected String generateHeader(String str) {
        if (this.isLastColumn()) {
            return str;
        }
        return DATA_COL_SEPARATOR_FORMAT.formatted(str, this.getTable().getColumnSeparator());
    }

    @Override
    public String generateData(Object data) {
        if (this.isLastColumn()) {
            return super.generateData(data);
        }
        return DATA_COL_SEPARATOR_FORMAT.formatted(super.generateData(data), this.getTable().getColumnSeparator());
    }

    protected String alignStringRight(String str) {
        return CsvTableColumn.alignStringRight(str, this.generateTitleHeader().length());
    }

    public static String alignStringRight(String str, int size) {
        String fmt = "%%%ds".formatted(size);
        return fmt.formatted(str);
    }
}

