/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import java.util.List;
import java.util.Objects;
import org.cloudsimplus.builders.tables.Table;
import org.cloudsimplus.builders.tables.TableBuilderAbstract;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.core.Identifiable;

public class CloudletsTableBuilder
extends TableBuilderAbstract<Cloudlet> {
    public static final String DEF_FORMAT = "%d";
    private static final String SECONDS = "Seconds";
    private static final String CPU_CORES = "CPU cores";
    private static final String ID = "ID";
    private static final String MI = "MI";
    private String timeFormat = "%.1f";
    private String idFormat = "%d";
    private String lengthFormat = "%d";
    private String peFormat = "%d";

    public CloudletsTableBuilder(List<? extends Cloudlet> list) {
        super(list);
    }

    public CloudletsTableBuilder(List<? extends Cloudlet> list, Table table) {
        super(list, table);
    }

    @Override
    protected void createTableColumns() {
        this.addColumn(this.getTable().newColumn("Cloudlet", ID), Identifiable::getId);
        this.addColumn(this.getTable().newColumn(" Status"), cloudlet -> cloudlet.getStatus().name());
        this.addColumn(this.getTable().newColumn("DC", ID, this.idFormat), cloudlet -> cloudlet.getVm().getHost().getDatacenter().getId());
        this.addColumn(this.getTable().newColumn("Host", ID, this.idFormat), cloudlet -> cloudlet.getVm().getHost().getId());
        this.addColumn(this.getTable().newColumn("Host PEs ", CPU_CORES, this.peFormat), cloudlet -> cloudlet.getVm().getHost().getWorkingPesNumber());
        this.addColumn(this.getTable().newColumn("VM", ID, this.idFormat), cloudlet -> cloudlet.getVm().getId());
        this.addColumn(this.getTable().newColumn("   VM PEs", CPU_CORES, this.peFormat), cloudlet -> cloudlet.getVm().getPesNumber());
        this.addColumn(this.getTable().newColumn("CloudletLen", MI, this.lengthFormat), Cloudlet::getLength);
        this.addColumn(this.getTable().newColumn("FinishedLen", MI, this.lengthFormat), Cloudlet::getFinishedLengthSoFar);
        this.addColumn(this.getTable().newColumn("CloudletPEs", CPU_CORES, this.peFormat), Cloudlet::getPesNumber);
        this.addColumn(this.getTable().newColumn("StartTime", SECONDS, this.timeFormat), Cloudlet::getExecStartTime);
        this.addColumn(this.getTable().newColumn("FinishTime", SECONDS, this.timeFormat), Cloudlet::getFinishTime);
        this.addColumn(this.getTable().newColumn("ExecTime", SECONDS, this.timeFormat), Cloudlet::getActualCpuTime);
    }

    public CloudletsTableBuilder setTimeFormat(String timeFormat) {
        this.timeFormat = Objects.requireNonNullElse(timeFormat, "");
        return this;
    }

    public CloudletsTableBuilder setLengthFormat(String lengthFormat) {
        this.lengthFormat = Objects.requireNonNullElse(lengthFormat, "");
        return this;
    }

    public CloudletsTableBuilder setIdFormat(String idFormat) {
        this.idFormat = Objects.requireNonNullElse(idFormat, "");
        return this;
    }

    public CloudletsTableBuilder setPeFormat(String peFormat) {
        this.peFormat = Objects.requireNonNullElse(peFormat, "");
        return this;
    }

    public final String getTimeFormat() {
        return this.timeFormat;
    }

    public final String getIdFormat() {
        return this.idFormat;
    }

    public final String getLengthFormat() {
        return this.lengthFormat;
    }

    public final String getPeFormat() {
        return this.peFormat;
    }
}

