/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.cloudsimplus.builders.tables.Table;
import org.cloudsimplus.builders.tables.TableColumn;

public abstract class AbstractTable
implements Table {
    private PrintStream printStream = System.out;
    private final List<TableColumn> columns = new ArrayList<TableColumn>();
    private String title;
    private final List<List<Object>> rows = new ArrayList<List<Object>>();
    private String columnSeparator;

    public AbstractTable() {
        this("");
    }

    public AbstractTable(String title) {
        this.setTitle(title);
    }

    @Override
    public int colCount() {
        return this.columns.size();
    }

    @Override
    public final Table setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
        return this;
    }

    @Override
    public final Table setColumnSeparator(@NonNull String columnSeparator) {
        if (columnSeparator == null) {
            throw new NullPointerException("columnSeparator is marked non-null but is null");
        }
        this.columnSeparator = columnSeparator;
        return this;
    }

    protected List<List<Object>> getRows() {
        return this.rows;
    }

    @Override
    public List<Object> newRow() {
        ArrayList<Object> row = new ArrayList<Object>();
        this.rows.add(row);
        return row;
    }

    private boolean isThereAnySubtitledColumn() {
        return this.columns.stream().anyMatch(col -> !col.getSubTitle().isBlank());
    }

    private void printRow(List<Object> row) {
        this.printStream.printf(this.rowOpening(), new Object[0]);
        List cols = this.columns.stream().limit(Math.min(this.columns.size(), row.size())).toList();
        int idxCol = 0;
        for (TableColumn col : cols) {
            this.printStream.print(col.generateData(row.get(idxCol++)));
        }
        this.printStream.printf(this.rowClosing(), new Object[0]);
    }

    @Override
    public void print() {
        this.printTableOpening();
        this.printTitle();
        this.printColumnHeaders();
        this.rows.forEach(this::printRow);
        this.printTableClosing();
    }

    protected void printColumnHeaders() {
        this.printStream.printf(this.rowOpening(), new Object[0]);
        this.columns.forEach(col -> this.printStream.print(col.generateTitleHeader()));
        this.printStream.printf(this.rowClosing(), new Object[0]);
        if (this.isThereAnySubtitledColumn()) {
            this.printSubtitleHeaders();
        }
    }

    private void printSubtitleHeaders() {
        this.printStream.printf(this.subtitleHeaderOpening(), new Object[0]);
        this.printStream.printf(this.rowOpening(), new Object[0]);
        this.columns.forEach(col -> this.printStream.printf(col.generateSubtitleHeader(), new Object[0]));
        this.printStream.printf(this.rowClosing(), new Object[0]);
    }

    protected abstract void printTableOpening();

    protected abstract void printTitle();

    protected abstract String rowOpening();

    protected abstract String rowClosing();

    protected abstract String subtitleHeaderOpening();

    protected abstract void printTableClosing();

    @Override
    public final Table addColumnList(String ... columnTitles) {
        for (String column : columnTitles) {
            this.newColumn(column);
        }
        return this;
    }

    @Override
    public final TableColumn newColumn(String title, String subTitle) {
        return this.newColumn(title).setSubTitle(subTitle);
    }

    @Override
    public final TableColumn newColumn(String title) {
        return this.newColumn(title, "", "");
    }

    protected final TableColumn addColumn(TableColumn column) {
        return this.addColumn(column, this.columns.size());
    }

    protected final TableColumn addColumn(TableColumn column, int index) {
        column.setTable(this);
        if (index > this.colCount()) {
            this.columns.add(column);
        } else {
            this.columns.add(index, column);
        }
        return column;
    }

    public final PrintStream getPrintStream() {
        return this.printStream;
    }

    @Override
    public final List<TableColumn> getColumns() {
        return this.columns;
    }

    @Override
    public final String getTitle() {
        return this.title;
    }

    @Override
    public final String getColumnSeparator() {
        return this.columnSeparator;
    }

    public final AbstractTable setPrintStream(PrintStream printStream) {
        this.printStream = printStream;
        return this;
    }
}

