/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders;

import org.cloudsimplus.builders.BrokerBuilder;
import org.cloudsimplus.builders.DatacenterBuilder;
import org.cloudsimplus.core.CloudSimPlus;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.vms.Vm;

public class SimulationScenarioBuilder {
    private final DatacenterBuilder datacenterBuilder;
    private final BrokerBuilder brokerBuilder;
    private final CloudSimPlus simulation;

    public SimulationScenarioBuilder(CloudSimPlus simulation) {
        this.simulation = simulation;
        this.datacenterBuilder = new DatacenterBuilder(this);
        this.brokerBuilder = new BrokerBuilder(this);
    }

    public DatacenterBuilder getDatacenterBuilder() {
        return this.datacenterBuilder;
    }

    public BrokerBuilder getBrokerBuilder() {
        return this.brokerBuilder;
    }

    public Host getHostOfDatacenter(int hostIndex, int datacenterIndex) {
        return this.datacenterBuilder.getHostOfDatacenter(hostIndex, datacenterIndex);
    }

    public Host getFirstHostFromFirstDatacenter() {
        return this.datacenterBuilder.getHostOfDatacenter(0, 0);
    }

    public Vm getFirstVmFromFirstBroker() {
        return this.getVmFromBroker(0, 0);
    }

    public Vm getVmFromBroker(int vmIndex, int brokerIndex) {
        return this.brokerBuilder.get(brokerIndex).getWaitingVm(vmIndex);
    }

    public CloudSimPlus getSimulation() {
        return this.simulation;
    }
}

