/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicySimple;
import org.cloudsimplus.builders.Builder;
import org.cloudsimplus.builders.SimulationScenarioBuilder;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.datacenters.DatacenterCharacteristics;
import org.cloudsimplus.datacenters.DatacenterSimple;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.resources.SanStorage;

public class DatacenterBuilder
implements Builder {
    private static final String DC_NAME_FORMAT = "Datacenter%d";
    private final SimulationScenarioBuilder scenario;
    private double costPerBwMegabit;
    private double costPerCpuSecond = 3.0;
    private double costPerStorage = 0.001;
    private double costPerMem = 0.05;
    private double schedulingInterval = -1.0;
    private int timezone;
    private final List<Datacenter> datacenters;
    private int createdDatacenters;
    private List<SanStorage> storageList;
    private Function<List<Host>, Datacenter> datacenterCreationFunction;

    public DatacenterBuilder(SimulationScenarioBuilder scenario) {
        this.scenario = scenario;
        this.datacenters = new ArrayList<Datacenter>();
        this.storageList = new ArrayList<SanStorage>();
        this.createdDatacenters = 0;
        this.datacenterCreationFunction = this::defaultDatacenterCreationFunction;
    }

    public DatacenterBuilder create(List<Host> hosts) {
        Objects.requireNonNull(hosts);
        if (hosts.isEmpty()) {
            throw new IllegalArgumentException("The hosts parameter has to have at least 1 host.");
        }
        String name = DC_NAME_FORMAT.formatted(this.createdDatacenters++);
        Datacenter datacenter = this.datacenterCreationFunction.apply(hosts);
        DatacenterCharacteristics characteristics = datacenter.getCharacteristics();
        characteristics.setCostPerSecond(this.costPerCpuSecond);
        characteristics.setCostPerMem(this.costPerMem);
        characteristics.setCostPerStorage(this.costPerStorage);
        characteristics.setCostPerBw(this.costPerBwMegabit);
        datacenter.getDatacenterStorage().setStorageList(this.storageList);
        datacenter.setName(name);
        datacenter.setTimeZone(this.timezone);
        this.datacenters.add(datacenter);
        return this;
    }

    public List<Datacenter> getDatacenters() {
        return this.datacenters;
    }

    public Datacenter get(int index) {
        if (index >= 0 && index < this.datacenters.size()) {
            return this.datacenters.get(index);
        }
        return Datacenter.NULL;
    }

    public Host getHostOfDatacenter(int hostIndex, int datacenterIndex) {
        return this.get(datacenterIndex).getHost(hostIndex);
    }

    public Host getFirstHostFromFirstDatacenter() {
        return this.getHostOfDatacenter(0, 0);
    }

    private Datacenter defaultDatacenterCreationFunction(List<Host> hosts) {
        DatacenterSimple dc = new DatacenterSimple(this.scenario.getSimulation(), hosts, new VmAllocationPolicySimple());
        dc.setSchedulingInterval(this.schedulingInterval);
        return dc;
    }

    public double getCostPerBwMegabit() {
        return this.costPerBwMegabit;
    }

    public DatacenterBuilder setCostPerBwMegabit(double defaultCostPerBwByte) {
        this.costPerBwMegabit = defaultCostPerBwByte;
        return this;
    }

    public double getCostPerCpuSecond() {
        return this.costPerCpuSecond;
    }

    public DatacenterBuilder setCostPerCpuSecond(double defaultCostPerCpuSecond) {
        this.costPerCpuSecond = defaultCostPerCpuSecond;
        return this;
    }

    public double getCostPerStorage() {
        return this.costPerStorage;
    }

    public DatacenterBuilder setCostPerStorage(double defaultCostPerStorage) {
        this.costPerStorage = defaultCostPerStorage;
        return this;
    }

    public double getCostPerMem() {
        return this.costPerMem;
    }

    public DatacenterBuilder setCostPerMem(double defaultCostPerMem) {
        this.costPerMem = defaultCostPerMem;
        return this;
    }

    public int getTimezone() {
        return this.timezone;
    }

    public DatacenterBuilder setTimezone(int defaultTimezone) {
        this.timezone = defaultTimezone;
        return this;
    }

    public double getSchedulingInterval() {
        return this.schedulingInterval;
    }

    public DatacenterBuilder setSchedulingInterval(double schedulingInterval) {
        this.schedulingInterval = schedulingInterval;
        return this;
    }

    public DatacenterBuilder setStorageList(List<SanStorage> storageList) {
        this.storageList = storageList;
        return this;
    }

    public DatacenterBuilder addStorageToList(SanStorage storage) {
        this.storageList.add(storage);
        return this;
    }

    public void setDatacenterCreationFunction(Function<List<Host>, Datacenter> datacenterCreationFunction) {
        this.datacenterCreationFunction = Objects.requireNonNull(datacenterCreationFunction);
    }
}

