/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.brokers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.NonNull;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.cloudsimplus.brokers.DatacenterBroker;
import org.cloudsimplus.brokers.VmCreation;
import org.cloudsimplus.cloudlets.Cloudlet;
import org.cloudsimplus.cloudlets.CloudletSimple;
import org.cloudsimplus.core.CloudSimEntity;
import org.cloudsimplus.core.CloudSimPlus;
import org.cloudsimplus.core.CloudSimTag;
import org.cloudsimplus.core.CustomerEntity;
import org.cloudsimplus.core.Simulation;
import org.cloudsimplus.core.events.CloudSimEvent;
import org.cloudsimplus.core.events.SimEvent;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.datacenters.TimeZoned;
import org.cloudsimplus.listeners.DatacenterBrokerEventInfo;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.util.InvalidEventDataTypeException;
import org.cloudsimplus.utilizationmodels.UtilizationModel;
import org.cloudsimplus.vms.Vm;
import org.cloudsimplus.vms.VmGroup;
import org.cloudsimplus.vms.VmSimple;

public abstract class DatacenterBrokerAbstract
extends CloudSimEntity
implements DatacenterBroker {
    private static final Function<Vm, Double> DEF_VM_DESTRUCTION_DELAY_FUNC = vm -> -1.0;
    private boolean selectClosestDatacenter;
    private final List<EventListener<DatacenterBrokerEventInfo>> onVmsCreatedListeners;
    private final VmCreation vmCreation;
    private final List<Vm> vmFailedList;
    private final List<Vm> vmWaitingList;
    private final List<Vm> vmExecList;
    private final List<Vm> vmCreatedList;
    private final List<Cloudlet> cloudletWaitingList;
    private final List<Cloudlet> cloudletSubmittedList;
    private final List<Cloudlet> cloudletFinishedList;
    private final List<Cloudlet> cloudletCreatedList;
    @NonNull
    private Datacenter lastSelectedDc;
    private Vm lastSelectedVm;
    @NonNull
    private BiFunction<Datacenter, Vm, Datacenter> datacenterMapper;
    @NonNull
    private Function<Cloudlet, Vm> vmMapper;
    private Function<Vm, Double> vmDestructionDelayFunction;
    private Comparator<Vm> vmComparator;
    private Comparator<Cloudlet> cloudletComparator;
    private List<Datacenter> datacenterList;
    private boolean wereThereWaitingCloudlets;
    private Cloudlet lastSubmittedCloudlet;
    private Vm lastSubmittedVm;
    private boolean shutdownRequested;
    private boolean shutdownWhenIdle;
    private boolean vmCreationRetrySent;

    public DatacenterBrokerAbstract(CloudSimPlus simulation, String name) {
        super(simulation);
        if (name != null && !name.isEmpty()) {
            this.setName(name);
        }
        this.onVmsCreatedListeners = new ArrayList<EventListener<DatacenterBrokerEventInfo>>();
        this.lastSubmittedCloudlet = Cloudlet.NULL;
        this.lastSubmittedVm = Vm.NULL;
        this.lastSelectedVm = Vm.NULL;
        this.lastSelectedDc = Datacenter.NULL;
        this.shutdownWhenIdle = true;
        this.vmCreation = new VmCreation();
        this.vmFailedList = new ArrayList<Vm>();
        this.vmWaitingList = new ArrayList<Vm>();
        this.vmExecList = new ArrayList<Vm>();
        this.vmCreatedList = new ArrayList<Vm>();
        this.cloudletWaitingList = new ArrayList<Cloudlet>();
        this.cloudletFinishedList = new ArrayList<Cloudlet>();
        this.cloudletCreatedList = new ArrayList<Cloudlet>();
        this.cloudletSubmittedList = new ArrayList<Cloudlet>();
        this.setDatacenterList(new ArrayList<Datacenter>());
        this.setDatacenterMapper(this::defaultDatacenterMapper);
        this.setVmMapper(this::defaultVmMapper);
        this.vmDestructionDelayFunction = DEF_VM_DESTRUCTION_DELAY_FUNC;
    }

    @Override
    public final DatacenterBroker setSelectClosestDatacenter(boolean select) {
        this.selectClosestDatacenter = select;
        if (select) {
            this.setDatacenterMapper(this::closestDatacenterMapper);
        }
        return this;
    }

    @Override
    public DatacenterBroker submitVmList(List<? extends Vm> list, double submissionDelay) {
        this.setDelayForEntitiesWithNoDelay(list, submissionDelay);
        return this.submitVmList(list);
    }

    @Override
    public DatacenterBroker submitVmList(List<? extends Vm> list) {
        this.sortVmsIfComparatorIsSet(list);
        this.configureEntities(list);
        this.lastSubmittedVm = this.setIdForEntitiesWithoutOne(list, this.lastSubmittedVm);
        this.vmWaitingList.addAll(list);
        if (this.isStarted() && !list.isEmpty()) {
            LOGGER.info("{}: {}: List of {} VMs submitted to the broker during simulation execution. VMs creation request sent to Datacenter.", new Object[]{this.getSimulation().clockStr(), this.getName(), list.size()});
            this.requestDatacentersToCreateWaitingCloudlets();
            if (!this.vmCreationRetrySent) {
                this.lastSelectedDc = Datacenter.NULL;
                this.requestDatacenterToCreateWaitingVms(false, false);
            }
        }
        return this;
    }

    private void configureEntities(List<? extends CustomerEntity> customerEntities) {
        for (CustomerEntity customerEntity : customerEntities) {
            customerEntity.setBroker(this);
            customerEntity.setArrivedTime(this.getSimulation().clock());
            if (!(customerEntity instanceof VmGroup)) continue;
            VmGroup vmGroup = (VmGroup)customerEntity;
            this.configureEntities(vmGroup.getVmList());
        }
    }

    private <T extends CustomerEntity> T setIdForEntitiesWithoutOne(List<? extends T> list, T lastSubmittedEntity) {
        return (T)((CustomerEntity)Simulation.setIdForEntitiesWithoutOne(list, lastSubmittedEntity));
    }

    private void sortVmsIfComparatorIsSet(List<? extends Vm> list) {
        if (this.vmComparator != null) {
            list.sort(this.vmComparator);
        }
    }

    @Override
    public DatacenterBroker submitVm(@NonNull Vm vm) {
        if (vm == null) {
            throw new NullPointerException("vm is marked non-null but is null");
        }
        if (Vm.NULL.equals(vm)) {
            return this;
        }
        ArrayList<Vm> newVmList = new ArrayList<Vm>(1);
        newVmList.add(vm);
        return this.submitVmList(newVmList);
    }

    @Override
    public DatacenterBroker submitCloudlet(@NonNull Cloudlet cloudlet) {
        if (cloudlet == null) {
            throw new NullPointerException("cloudlet is marked non-null but is null");
        }
        if (cloudlet == Cloudlet.NULL) {
            return this;
        }
        ArrayList<Cloudlet> newCloudletList = new ArrayList<Cloudlet>(1);
        newCloudletList.add(cloudlet);
        return this.submitCloudletList(newCloudletList);
    }

    @Override
    public DatacenterBroker submitCloudletList(List<? extends Cloudlet> list, double submissionDelay) {
        return this.submitCloudletList(list, Vm.NULL, submissionDelay);
    }

    @Override
    public DatacenterBroker submitCloudletList(List<? extends Cloudlet> list, Vm vm) {
        return this.submitCloudletList(list, vm, -1.0);
    }

    @Override
    public DatacenterBroker submitCloudletList(List<? extends Cloudlet> list, Vm vm, double submissionDelay) {
        this.setDelayForEntitiesWithNoDelay(list, submissionDelay);
        this.bindCloudletsToVm(list, vm);
        return this.submitCloudletList(list);
    }

    @Override
    public DatacenterBroker submitCloudletList(List<? extends Cloudlet> list) {
        if (list.isEmpty()) {
            return this;
        }
        this.sortCloudletsIfComparatorIsSet(list);
        this.configureEntities(list);
        this.lastSubmittedCloudlet = this.setIdForEntitiesWithoutOne(list, this.lastSubmittedCloudlet);
        this.cloudletSubmittedList.addAll(list);
        this.setSimulationForCloudletUtilizationModels(list);
        this.cloudletWaitingList.addAll(list);
        this.wereThereWaitingCloudlets = true;
        if (!this.isStarted()) {
            return this;
        }
        LOGGER.info("{}: {}: List of {} Cloudlets submitted to the broker during simulation execution.", new Object[]{this.getSimulation().clockStr(), this.getName(), list.size()});
        LOGGER.info("Cloudlets creation request sent to Datacenter.");
        this.requestDatacentersToCreateWaitingCloudlets();
        return this;
    }

    private void bindCloudletsToVm(List<? extends Cloudlet> cloudlets, Vm vm) {
        if (Vm.NULL.equals(vm)) {
            return;
        }
        cloudlets.forEach(c -> c.setVm(vm));
    }

    private void sortCloudletsIfComparatorIsSet(List<? extends Cloudlet> cloudlets) {
        if (this.cloudletComparator != null) {
            cloudlets.sort(this.cloudletComparator);
        }
    }

    private void setSimulationForCloudletUtilizationModels(List<? extends Cloudlet> cloudletList) {
        for (Cloudlet cloudlet : cloudletList) {
            this.setSimulationForUtilizationModel(cloudlet.getUtilizationModelCpu());
            this.setSimulationForUtilizationModel(cloudlet.getUtilizationModelBw());
            this.setSimulationForUtilizationModel(cloudlet.getUtilizationModelRam());
        }
    }

    private void setSimulationForUtilizationModel(UtilizationModel cloudletUtilizationModel) {
        if (cloudletUtilizationModel.getSimulation() == null || cloudletUtilizationModel.getSimulation() == Simulation.NULL) {
            cloudletUtilizationModel.setSimulation(this.getSimulation());
        }
    }

    private void setDelayForEntitiesWithNoDelay(List<? extends CustomerEntity> entities, double submissionDelay) {
        if (submissionDelay < 0.0) {
            return;
        }
        entities.stream().filter(entity -> entity.getSubmissionDelay() <= 0.0).forEach(entity -> entity.setSubmissionDelay(submissionDelay));
    }

    @Override
    public boolean bindCloudletToVm(Cloudlet cloudlet, Vm vm) {
        if (!this.equals(cloudlet.getBroker()) && !DatacenterBroker.NULL.equals(cloudlet.getBroker())) {
            return false;
        }
        cloudlet.setVm(vm);
        return true;
    }

    @Override
    public void processEvent(SimEvent evt) {
        if (this.processCloudletEvents(evt) || this.processVmEvents(evt) || this.processGeneralEvents(evt)) {
            return;
        }
        LOGGER.trace("{}: {}: Unknown event {} received.", new Object[]{this.getSimulation().clockStr(), this, evt.getTag()});
    }

    private boolean processCloudletEvents(SimEvent evt) {
        return switch (evt.getTag()) {
            case CloudSimTag.CLOUDLET_RETURN -> this.processCloudletReturn(evt);
            case CloudSimTag.CLOUDLET_READY -> this.processCloudletReady(evt);
            case CloudSimTag.CLOUDLET_UPDATE_ATTRIBUTES -> this.executeRunnableEvent(evt);
            case CloudSimTag.CLOUDLET_PAUSE -> this.processCloudletPause(evt);
            case CloudSimTag.CLOUDLET_CANCEL -> this.processCloudletCancel(evt);
            case CloudSimTag.CLOUDLET_FINISH -> this.processCloudletFinish(evt);
            case CloudSimTag.CLOUDLET_FAIL -> this.processCloudletFail(evt);
            default -> false;
        };
    }

    private boolean executeRunnableEvent(SimEvent evt) {
        Object object = evt.getData();
        if (object instanceof Runnable) {
            Runnable runnable = (Runnable)object;
            runnable.run();
            return true;
        }
        throw new InvalidEventDataTypeException(evt, "CLOUDLET_UPDATE_ATTRIBUTES", "Runnable");
    }

    private boolean processVmEvents(SimEvent evt) {
        return switch (evt.getTag()) {
            case CloudSimTag.VM_CREATE_RETRY -> {
                this.vmCreationRetrySent = false;
                yield this.requestDatacenterToCreateWaitingVms(false, true);
            }
            case CloudSimTag.VM_CREATE_ACK -> this.processVmCreateResponseFromDatacenter(evt);
            case CloudSimTag.VM_VERTICAL_SCALING -> this.requestVmVerticalScaling(evt);
            default -> false;
        };
    }

    private boolean processGeneralEvents(SimEvent evt) {
        if (evt.getTag() == CloudSimTag.DC_LIST_REQUEST) {
            this.processDatacenterListRequest(evt);
            return true;
        }
        if (evt.getTag() == CloudSimTag.ENTITY_SHUTDOWN || evt.getTag() == CloudSimTag.SIMULATION_END) {
            this.shutdown();
            return true;
        }
        return false;
    }

    private boolean processCloudletReady(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        if (cloudlet.getStatus() == Cloudlet.Status.PAUSED) {
            this.logCloudletStatusChange(cloudlet, "resume execution of");
        } else {
            this.logCloudletStatusChange(cloudlet, "start executing");
        }
        cloudlet.getVm().getCloudletScheduler().cloudletReady(cloudlet);
        return true;
    }

    private boolean processCloudletPause(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        this.logCloudletStatusChange(cloudlet, "de-schedule (pause)");
        cloudlet.getVm().getCloudletScheduler().cloudletPause(cloudlet);
        return true;
    }

    private boolean processCloudletCancel(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        this.logCloudletStatusChange(cloudlet, "cancel execution of");
        cloudlet.getVm().getCloudletScheduler().cloudletCancel(cloudlet);
        return true;
    }

    private boolean processCloudletFinish(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        this.logCloudletStatusChange(cloudlet, "finish running");
        if (cloudlet.getFinishedLengthSoFar() == 0L) {
            this.updateHostProcessing(cloudlet);
        }
        if (cloudlet.getFinishedLengthSoFar() == 0L) {
            cloudlet.getVm().getCloudletScheduler().cloudletFail(cloudlet);
            return true;
        }
        long prevLength = cloudlet.getLength();
        cloudlet.setLength(cloudlet.getFinishedLengthSoFar());
        this.updateHostProcessing(cloudlet);
        if (prevLength < 0L) {
            double delay = cloudlet.getSimulation().getMinTimeBetweenEvents();
            Datacenter dc = cloudlet.getVm().getHost().getDatacenter();
            dc.schedule(delay, CloudSimTag.VM_UPDATE_CLOUDLET_PROCESSING);
        }
        return true;
    }

    private void updateHostProcessing(Cloudlet cloudlet) {
        cloudlet.getVm().getHost().updateProcessing(this.getSimulation().clock());
    }

    private void logCloudletStatusChange(Cloudlet cloudlet, String status) {
        String msg = cloudlet.getJobId() > 0L ? "(job %d) ".formatted(cloudlet.getJobId()) : "";
        LOGGER.info("{}: {}: Request to {} {} {}received.", new Object[]{this.getSimulation().clockStr(), this.getName(), status, cloudlet, msg});
    }

    private boolean processCloudletFail(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        cloudlet.getVm().getCloudletScheduler().cloudletFail(cloudlet);
        return true;
    }

    private boolean requestVmVerticalScaling(SimEvent evt) {
        Object object = evt.getData();
        if (object instanceof VerticalVmScaling) {
            VerticalVmScaling scaling = (VerticalVmScaling)object;
            this.getSimulation().sendNow(evt.getSource(), scaling.getVm().getHost().getDatacenter(), CloudSimTag.VM_VERTICAL_SCALING, scaling);
            return true;
        }
        throw new InvalidEventDataTypeException(evt, "VM_VERTICAL_SCALING", "VerticalVmScaling");
    }

    private void processDatacenterListRequest(SimEvent evt) {
        Object object = evt.getData();
        if (object instanceof List) {
            List dcList = (List)object;
            this.setDatacenterList(dcList);
            LOGGER.info("{}: {}: List of {} datacenters(s) received.", new Object[]{this.getSimulation().clockStr(), this.getName(), this.datacenterList.size()});
            this.requestDatacenterToCreateWaitingVms(false, false);
            return;
        }
        throw new InvalidEventDataTypeException(evt, "DC_LIST_REQUEST", "List<Datacenter>");
    }

    private boolean processVmCreateResponseFromDatacenter(SimEvent evt) {
        Vm vm = (Vm)evt.getData();
        if (vm.isCreated()) {
            this.processSuccessVmCreationInDatacenter(vm);
            vm.notifyOnHostAllocationListeners();
        } else {
            vm.setFailed(true);
            if (!this.vmCreation.isRetryFailedVms()) {
                this.vmWaitingList.remove(vm);
                this.vmFailedList.add(vm);
                LOGGER.warn("{}: {}: {} has been moved to the failed list because creation retry is not enabled.", new Object[]{this.getSimulation().clockStr(), this.getName(), vm});
            }
            vm.notifyOnCreationFailureListeners(this.lastSelectedDc);
        }
        this.vmCreation.incCreationRequests(-1);
        if (this.vmCreation.getCreationRequests() == 0 && !this.vmWaitingList.isEmpty()) {
            this.requestCreationOfWaitingVmsToFallbackDatacenter();
        }
        if (this.allNonDelayedVmsCreated()) {
            this.requestDatacentersToCreateWaitingCloudlets();
        }
        return vm.isCreated();
    }

    private boolean allNonDelayedVmsCreated() {
        return this.vmWaitingList.stream().noneMatch(vm -> vm.getSubmissionDelay() == 0.0);
    }

    private void notifyOnVmsCreatedListeners() {
        if (!this.vmWaitingList.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.onVmsCreatedListeners.size(); ++i) {
            EventListener<DatacenterBrokerEventInfo> listener = this.onVmsCreatedListeners.get(i);
            listener.update(DatacenterBrokerEventInfo.of(listener, this));
        }
        if (this.vmWaitingList.isEmpty()) {
            this.vmCreation.resetCurrentRetries();
        }
    }

    private void requestCreationOfWaitingVmsToFallbackDatacenter() {
        this.lastSelectedDc = Datacenter.NULL;
        if (this.vmWaitingList.isEmpty() || this.requestDatacenterToCreateWaitingVms(false, true)) {
            return;
        }
        String msg = "{}: {}: {} of the requested {} VMs couldn't be created because suitable Hosts weren't found in any available Datacenter." + (this.vmExecList.isEmpty() && !this.vmCreation.isRetryFailedVms() ? " Shutting broker down..." : "");
        LOGGER.error(msg, new Object[]{this.getSimulation().clockStr(), this.getName(), this.vmWaitingList.size(), this.getVmsNumber()});
        if (!this.vmWaitingList.isEmpty()) {
            this.processVmCreationFailure();
            return;
        }
        this.requestDatacentersToCreateWaitingCloudlets();
    }

    private void processVmCreationFailure() {
        if (this.vmCreation.isRetryFailedVms()) {
            this.lastSelectedDc = this.datacenterList.get(0);
            this.vmCreationRetrySent = true;
            this.schedule(this.vmCreation.getRetryDelay(), CloudSimTag.VM_CREATE_RETRY);
            this.vmCreation.incCurrentRetries();
        } else {
            this.shutdown();
        }
    }

    private boolean requestDatacenterToCreateWaitingVms(boolean isFallbackDatacenter, boolean creationRetry) {
        for (Vm vm : this.vmWaitingList) {
            this.lastSelectedDc = this.getLastSelectedDc(isFallbackDatacenter, vm);
            if (creationRetry) {
                vm.setLastTriedDatacenter(Datacenter.NULL);
            }
            this.vmCreation.incCreationRequests(this.requestVmCreation(this.lastSelectedDc, isFallbackDatacenter, vm));
        }
        return this.lastSelectedDc != Datacenter.NULL;
    }

    private Datacenter getLastSelectedDc(boolean isFallbackDatacenter, Vm vm) {
        return isFallbackDatacenter && this.selectClosestDatacenter ? this.defaultDatacenterMapper(this.lastSelectedDc, vm) : this.datacenterMapper.apply(this.lastSelectedDc, vm);
    }

    @Override
    public int getVmsNumber() {
        return this.vmCreatedList.size() + this.vmWaitingList.size() + this.vmFailedList.size();
    }

    private void processSuccessVmCreationInDatacenter(Vm vm) {
        if (vm instanceof VmGroup) {
            VmGroup vmGroup = (VmGroup)vm;
            int createdVms = 0;
            for (Vm nextVm : vmGroup.getVmList()) {
                if (!nextVm.isCreated()) continue;
                this.processSuccessVmCreationInDatacenter(nextVm);
                ++createdVms;
            }
            if (createdVms == vmGroup.size()) {
                this.vmWaitingList.remove(vmGroup);
            }
            return;
        }
        this.vmWaitingList.remove(vm);
        this.vmExecList.add(vm);
        this.vmCreatedList.add(vm);
        this.notifyOnVmsCreatedListeners();
    }

    private boolean processCloudletReturn(SimEvent evt) {
        Cloudlet cloudlet = (Cloudlet)evt.getData();
        this.cloudletFinishedList.add(cloudlet);
        ((VmSimple)cloudlet.getVm()).addExpectedFreePesNumber(cloudlet.getPesNumber());
        String lifeTime = cloudlet.getLifeTime() == -1.0 ? "" : " (after defined lifetime expired)";
        LOGGER.info("{}: {}: {} finished{} in {} and returned to broker.", new Object[]{this.getSimulation().clockStr(), this.getName(), cloudlet, lifeTime, cloudlet.getVm()});
        if (cloudlet.getVm().getCloudletScheduler().isEmpty()) {
            this.requestIdleVmDestruction(cloudlet.getVm());
            return true;
        }
        this.requestVmDestructionAfterAllCloudletsFinished();
        return true;
    }

    private void requestVmDestructionAfterAllCloudletsFinished() {
        for (int i = this.vmExecList.size() - 1; i >= 0; --i) {
            this.requestIdleVmDestruction(this.vmExecList.get(i));
        }
        if (this.cloudletWaitingList.isEmpty()) {
            return;
        }
        this.requestDatacenterToCreateWaitingVms(false, false);
    }

    @Override
    public DatacenterBroker requestIdleVmDestruction(Vm vm) {
        if (vm.isCreated()) {
            if (this.isVmIdleEnough(vm) || this.isFinished()) {
                LOGGER.info("{}: {}: Requesting {} destruction.", new Object[]{this.getSimulation().clockStr(), this.getName(), vm});
                this.sendNow(this.getDatacenter(vm), CloudSimTag.VM_DESTROY, vm);
            }
            if (this.isVmIdlenessVerificationRequired((VmSimple)vm)) {
                this.getSimulation().send(new CloudSimEvent(this.vmDestructionDelayFunction.apply(vm), vm.getHost().getDatacenter(), CloudSimTag.VM_UPDATE_CLOUDLET_PROCESSING));
                return this;
            }
        }
        this.requestShutdownWhenIdle();
        return this;
    }

    private boolean isVmIdleEnough(Vm vm) {
        double delay = this.vmDestructionDelayFunction.apply(vm);
        return delay > -1.0 && vm.isIdleEnough(delay);
    }

    @Override
    public void requestShutdownWhenIdle() {
        if (!this.shutdownRequested && this.isTimeToShutdownBroker()) {
            this.schedule(CloudSimTag.ENTITY_SHUTDOWN);
            this.shutdownRequested = true;
        }
    }

    @Override
    public List<Cloudlet> destroyVm(Vm vm) {
        if (!vm.isCreated()) {
            LOGGER.warn("Vm: " + vm.getId() + " does not belong to this broker! Broker: " + this);
            return new ArrayList<Cloudlet>();
        }
        ArrayList<Cloudlet> cloudletsAffectedList = new ArrayList<Cloudlet>();
        Iterator<Cloudlet> iterator = this.cloudletSubmittedList.iterator();
        while (iterator.hasNext()) {
            Cloudlet cloudlet = iterator.next();
            if (!cloudlet.getVm().equals(vm) || cloudlet.isFinished()) continue;
            cloudlet.setVm(Vm.NULL);
            cloudletsAffectedList.add(cloudlet.reset());
            iterator.remove();
        }
        vm.getHost().destroyVm(vm);
        vm.getCloudletScheduler().clear();
        return cloudletsAffectedList;
    }

    private boolean isVmIdlenessVerificationRequired(VmSimple vm) {
        if (vm.hasStartedSomeCloudlet() && vm.getCloudletScheduler().isEmpty()) {
            int schedulingInterval = (int)vm.getHost().getDatacenter().getSchedulingInterval();
            int delay = this.vmDestructionDelayFunction.apply(vm).intValue();
            return (double)delay > -1.0 && (schedulingInterval <= 0 || delay % schedulingInterval != 0);
        }
        return false;
    }

    private boolean isTimeToShutdownBroker() {
        return this.isAlive() && this.isTimeToTerminateSimulation() && this.shutdownWhenIdle && this.isBrokerIdle();
    }

    private boolean isTimeToTerminateSimulation() {
        return !this.getSimulation().isTerminationTimeSet() || this.getSimulation().isTimeToTerminateSimulationUnderRequest();
    }

    private boolean isBrokerIdle() {
        return this.cloudletWaitingList.isEmpty() && this.vmWaitingList.isEmpty() && this.vmExecList.isEmpty();
    }

    private int requestVmCreation(Datacenter dc, boolean isFallbackDatacenter, Vm vm) {
        if (dc == Datacenter.NULL || dc.equals(vm.getLastTriedDatacenter())) {
            return 0;
        }
        this.logVmCreationRequest(dc, isFallbackDatacenter, vm);
        this.send(dc, vm.getSubmissionDelay(), CloudSimTag.VM_CREATE_ACK, vm);
        vm.setLastTriedDatacenter(dc);
        return 1;
    }

    private void logVmCreationRequest(Datacenter datacenter, boolean isFallbackDatacenter, Vm vm) {
        String fallbackMsg;
        String string = fallbackMsg = isFallbackDatacenter ? " (due to lack of a suitable Host in previous one)" : "";
        if (vm.getSubmissionDelay() == 0.0) {
            LOGGER.info("{}: {}: Trying to create {} in {}{}", new Object[]{this.getSimulation().clockStr(), this.getName(), vm, datacenter.getName(), fallbackMsg});
        } else {
            LOGGER.info("{}: {}: Creation of {} in {}{} will be requested in {} seconds", new Object[]{this.getSimulation().clockStr(), this.getName(), vm, datacenter.getName(), fallbackMsg, vm.getSubmissionDelay()});
        }
    }

    protected void requestDatacentersToCreateWaitingCloudlets() {
        int createdCloudlets = 0;
        Iterator<Cloudlet> iterator = this.cloudletWaitingList.iterator();
        while (iterator.hasNext()) {
            CloudletSimple cloudlet = (CloudletSimple)iterator.next();
            if (!cloudlet.getLastTriedDatacenter().equals(Datacenter.NULL)) continue;
            this.lastSelectedVm = this.vmMapper.apply(cloudlet);
            if (!this.lastSelectedVm.isCreated()) {
                this.logPostponingCloudletExecution(cloudlet);
                continue;
            }
            ((VmSimple)this.lastSelectedVm).removeExpectedFreePesNumber(cloudlet.getPesNumber());
            this.logCloudletCreationRequest(cloudlet);
            cloudlet.setVm(this.lastSelectedVm);
            Datacenter dc = this.getDatacenter(this.lastSelectedVm);
            this.send(dc, cloudlet.getSubmissionDelay(), CloudSimTag.CLOUDLET_SUBMIT, cloudlet);
            cloudlet.setLastTriedDatacenter(dc);
            this.cloudletCreatedList.add(cloudlet);
            iterator.remove();
            ++createdCloudlets;
        }
        this.allWaitingCloudletsSubmittedToVm(createdCloudlets);
    }

    private void logPostponingCloudletExecution(Cloudlet cloudlet) {
        if (this.getSimulation().isAborted() || this.getSimulation().isAbortRequested()) {
            return;
        }
        Vm vm = cloudlet.getVm();
        String vmMsg = Vm.NULL.equals(vm) ? "it couldn't be mapped to any VM" : "bind Vm %d is not available".formatted(vm.getId());
        String msg = "%s: %s: Postponing execution of Cloudlet %d because {}.".formatted(this.getSimulation().clockStr(), this.getName(), cloudlet.getId());
        if (vm.getSubmissionDelay() <= 0.0) {
            LOGGER.warn(msg, (Object)vmMsg);
            return;
        }
        String secs = vm.getSubmissionDelay() > 1.0 ? "seconds" : "second";
        String reason = "bind Vm %d was requested to be created with %.2f %s delay".formatted(vm.getId(), vm.getSubmissionDelay(), secs);
        LOGGER.info(msg, (Object)reason);
    }

    private void logCloudletCreationRequest(Cloudlet cloudlet) {
        String delayMsg = cloudlet.getSubmissionDelay() > 0.0 ? " with a requested delay of %.0f seconds".formatted(cloudlet.getSubmissionDelay()) : "";
        LOGGER.info("{}: {}: Sending Cloudlet {} to {} in {}{}.", new Object[]{this.getSimulation().clockStr(), this.getName(), cloudlet.getId(), this.lastSelectedVm, this.lastSelectedVm.getHost(), delayMsg});
    }

    private boolean allWaitingCloudletsSubmittedToVm(int createdCloudlets) {
        if (!this.cloudletWaitingList.isEmpty()) {
            return false;
        }
        if (this.wereThereWaitingCloudlets) {
            LOGGER.info("{}: {}: All {} waiting Cloudlets submitted to some VM.", new Object[]{this.getSimulation().clockStr(), this.getName(), createdCloudlets});
            this.wereThereWaitingCloudlets = false;
        }
        return true;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        LOGGER.info("{}: {} is shutting down...", (Object)this.getSimulation().clockStr(), (Object)this.getName());
        this.requestVmDestructionAfterAllCloudletsFinished();
    }

    @Override
    public void startInternal() {
        LOGGER.info("{} is starting...", (Object)this.getName());
        this.schedule(this.getSimulation().getCis(), 0.0, CloudSimTag.DC_LIST_REQUEST);
    }

    @Override
    public <T extends Vm> List<T> getVmCreatedList() {
        return this.vmCreatedList;
    }

    @Override
    public <T extends Vm> List<T> getVmExecList() {
        return this.vmExecList;
    }

    @Override
    public <T extends Vm> List<T> getVmWaitingList() {
        return this.vmWaitingList;
    }

    @Override
    public <T extends Vm> List<T> getVmFailedList() {
        return this.vmFailedList;
    }

    @Override
    public Vm getWaitingVm(int index) {
        if (index >= 0 && index < this.vmWaitingList.size()) {
            return this.vmWaitingList.get(index);
        }
        return Vm.NULL;
    }

    @Override
    public <T extends Cloudlet> List<T> getCloudletWaitingList() {
        return this.cloudletWaitingList;
    }

    @Override
    public <T extends Cloudlet> List<T> getCloudletFinishedList() {
        return new ArrayList<Cloudlet>(this.cloudletFinishedList);
    }

    protected Vm getVmFromCreatedList(int vmIndex) {
        return vmIndex >= 0 && vmIndex < this.vmExecList.size() ? this.vmExecList.get(vmIndex) : Vm.NULL;
    }

    private void setDatacenterList(List<Datacenter> datacenterList) {
        this.datacenterList = new ArrayList<Datacenter>(datacenterList);
        if (this.selectClosestDatacenter) {
            this.datacenterList.sort(Comparator.comparingDouble(TimeZoned::getTimeZone));
        }
    }

    protected Datacenter getDatacenter(Vm vm) {
        return vm.getHost().getDatacenter();
    }

    @Override
    public DatacenterBroker addOnVmsCreatedListener(@NonNull EventListener<DatacenterBrokerEventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.onVmsCreatedListeners.add(listener);
        return this;
    }

    @Override
    public DatacenterBroker removeOnVmsCreatedListener(@NonNull EventListener<? extends EventInfo> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.onVmsCreatedListeners.remove(listener);
        return this;
    }

    public String toString() {
        return "Broker " + this.getId();
    }

    @Override
    public DatacenterBroker setVmDestructionDelay(double delay) {
        if (delay <= this.getSimulation().getMinTimeBetweenEvents() && delay != -1.0) {
            String msg = "The delay should be larger then the simulation minTimeBetweenEvents to ensure VMs are gracefully shutdown.";
            throw new IllegalArgumentException("The delay should be larger then the simulation minTimeBetweenEvents to ensure VMs are gracefully shutdown.");
        }
        this.setVmDestructionDelayFunction(vm -> delay);
        return this;
    }

    @Override
    public DatacenterBroker setVmDestructionDelayFunction(Function<Vm, Double> function) {
        this.vmDestructionDelayFunction = function == null ? DEF_VM_DESTRUCTION_DELAY_FUNC : function;
        return this;
    }

    protected Datacenter closestDatacenterMapper(Datacenter lastDatacenter, Vm vm) {
        return TimeZoned.closestDatacenter(vm, this.getDatacenterList());
    }

    protected abstract Datacenter defaultDatacenterMapper(Datacenter var1, Vm var2);

    protected abstract Vm defaultVmMapper(Cloudlet var1);

    @Override
    public final boolean isSelectClosestDatacenter() {
        return this.selectClosestDatacenter;
    }

    @Override
    public final VmCreation getVmCreation() {
        return this.vmCreation;
    }

    @Override
    public final List<Cloudlet> getCloudletSubmittedList() {
        return this.cloudletSubmittedList;
    }

    @Override
    public final List<Cloudlet> getCloudletCreatedList() {
        return this.cloudletCreatedList;
    }

    @Override
    @NonNull
    public final Datacenter getLastSelectedDc() {
        return this.lastSelectedDc;
    }

    @NonNull
    public final BiFunction<Datacenter, Vm, Datacenter> getDatacenterMapper() {
        return this.datacenterMapper;
    }

    @Override
    public final boolean isShutdownWhenIdle() {
        return this.shutdownWhenIdle;
    }

    @Override
    public final DatacenterBrokerAbstract setLastSelectedDc(@NonNull Datacenter lastSelectedDc) {
        if (lastSelectedDc == null) {
            throw new NullPointerException("lastSelectedDc is marked non-null but is null");
        }
        this.lastSelectedDc = lastSelectedDc;
        return this;
    }

    @Override
    public final DatacenterBrokerAbstract setDatacenterMapper(@NonNull BiFunction<Datacenter, Vm, Datacenter> datacenterMapper) {
        if (datacenterMapper == null) {
            throw new NullPointerException("datacenterMapper is marked non-null but is null");
        }
        this.datacenterMapper = datacenterMapper;
        return this;
    }

    @Override
    public final DatacenterBrokerAbstract setVmMapper(@NonNull Function<Cloudlet, Vm> vmMapper) {
        if (vmMapper == null) {
            throw new NullPointerException("vmMapper is marked non-null but is null");
        }
        this.vmMapper = vmMapper;
        return this;
    }

    @Override
    public final DatacenterBrokerAbstract setVmComparator(Comparator<Vm> vmComparator) {
        this.vmComparator = vmComparator;
        return this;
    }

    @Override
    public final DatacenterBrokerAbstract setCloudletComparator(Comparator<Cloudlet> cloudletComparator) {
        this.cloudletComparator = cloudletComparator;
        return this;
    }

    @Override
    public final DatacenterBrokerAbstract setShutdownWhenIdle(boolean shutdownWhenIdle) {
        this.shutdownWhenIdle = shutdownWhenIdle;
        return this;
    }

    protected final List<Datacenter> getDatacenterList() {
        return this.datacenterList;
    }
}

