/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.autoscaling.resources;

import java.util.function.Function;
import lombok.NonNull;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.cloudsimplus.autoscaling.resources.ResourceScaling;
import org.cloudsimplus.autoscaling.resources.ResourceScalingGradual;
import org.cloudsimplus.resources.Resource;
import org.cloudsimplus.vms.Vm;

public class ResourceScalingInstantaneous
implements ResourceScaling {
    private static final ResourceScaling GRADUAL = new ResourceScalingGradual();

    @Override
    public double getResourceAmountToScale(@NonNull VerticalVmScaling vmScaling) {
        if (vmScaling == null) {
            throw new NullPointerException("vmScaling is marked non-null but is null");
        }
        Function<Vm, Double> thresholdFunc = vmScaling.getResourceUsageThresholdFunction();
        Resource res = vmScaling.getResource();
        double newTotalCapacity = Math.ceil((double)res.getAllocatedResource() / thresholdFunc.apply(vmScaling.getVm()));
        double scaleCapacity = newTotalCapacity - (double)res.getCapacity();
        double extraSafetyCapacity = GRADUAL.getResourceAmountToScale(vmScaling);
        return scaleCapacity + extraSafetyCapacity;
    }
}

