/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.autoscaling;

import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.NonNull;
import org.cloudsimplus.autoscaling.HorizontalVmScaling;
import org.cloudsimplus.autoscaling.VmScalingAbstract;
import org.cloudsimplus.listeners.VmHostEventInfo;
import org.cloudsimplus.vms.Vm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HorizontalVmScalingSimple
extends VmScalingAbstract
implements HorizontalVmScaling {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HorizontalVmScalingSimple.class.getSimpleName());
    @NonNull
    private Supplier<Vm> vmSupplier;
    private long cloudletCreationRequests;
    @NonNull
    private Predicate<Vm> overloadPredicate = FALSE_PREDICATE;

    public HorizontalVmScalingSimple() {
        this.vmSupplier = () -> Vm.NULL;
    }

    @Override
    protected boolean requestUpScaling(double time) {
        if (!this.haveNewCloudletsArrived()) {
            return false;
        }
        double vmCpuUsagePercent = this.getVm().getCpuPercentUtilization() * 100.0;
        Vm newVm = this.getVmSupplier().get();
        String timeStr = "%.2f".formatted(time);
        LOGGER.info("{}: {}{}: Requesting creation of {} to receive new Cloudlets in order to balance load of {}. {} CPU usage is {}%", new Object[]{timeStr, this.getClass().getSimpleName(), this.getVm(), newVm, this.getVm(), this.getVm().getId(), vmCpuUsagePercent});
        this.getVm().getBroker().submitVm(newVm);
        this.cloudletCreationRequests = this.getVm().getBroker().getCloudletCreatedList().size();
        return true;
    }

    private boolean haveNewCloudletsArrived() {
        return (long)this.getVm().getBroker().getCloudletCreatedList().size() > this.cloudletCreationRequests;
    }

    @Override
    public final boolean requestUpScalingIfPredicateMatches(VmHostEventInfo evt) {
        if (this.isTimeToCheckPredicate(evt.getTime())) {
            this.setLastProcessingTime(evt.getTime());
            return this.overloadPredicate.test(this.getVm()) && this.requestUpScaling(evt.getTime());
        }
        return false;
    }

    @Override
    @NonNull
    public final Supplier<Vm> getVmSupplier() {
        return this.vmSupplier;
    }

    @Override
    public final HorizontalVmScalingSimple setVmSupplier(@NonNull Supplier<Vm> vmSupplier) {
        if (vmSupplier == null) {
            throw new NullPointerException("vmSupplier is marked non-null but is null");
        }
        this.vmSupplier = vmSupplier;
        return this;
    }

    @Override
    @NonNull
    public final Predicate<Vm> getOverloadPredicate() {
        return this.overloadPredicate;
    }

    @Override
    public final HorizontalVmScalingSimple setOverloadPredicate(@NonNull Predicate<Vm> overloadPredicate) {
        if (overloadPredicate == null) {
            throw new NullPointerException("overloadPredicate is marked non-null but is null");
        }
        this.overloadPredicate = overloadPredicate;
        return this;
    }
}

