/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.allocationpolicies.migration;

import java.util.Optional;
import java.util.function.BiFunction;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicy;
import org.cloudsimplus.allocationpolicies.migration.VmAllocationPolicyMigrationAbstract;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.selectionpolicies.VmSelectionPolicy;
import org.cloudsimplus.vms.Vm;

public class VmAllocationPolicyMigrationStaticThreshold
extends VmAllocationPolicyMigrationAbstract {
    public static final double DEF_OVER_UTILIZATION_THRESHOLD = 0.9;
    private double overUtilizationThreshold;

    public VmAllocationPolicyMigrationStaticThreshold(VmSelectionPolicy vmSelectionPolicy) {
        this(vmSelectionPolicy, 0.9, null);
    }

    public VmAllocationPolicyMigrationStaticThreshold(VmSelectionPolicy vmSelectionPolicy, double overUtilizationThreshold) {
        this(vmSelectionPolicy, overUtilizationThreshold, null);
    }

    public VmAllocationPolicyMigrationStaticThreshold(VmSelectionPolicy vmSelectionPolicy, double overUtilizationThreshold, BiFunction<VmAllocationPolicy, Vm, Optional<Host>> findHostForVmFunction) {
        super(vmSelectionPolicy, findHostForVmFunction);
        this.setOverUtilizationThreshold(overUtilizationThreshold);
    }

    public final void setOverUtilizationThreshold(double overUtilizationThreshold) {
        if (overUtilizationThreshold <= 0.0 || overUtilizationThreshold >= 1.0) {
            throw new IllegalArgumentException("Over utilization threshold must be greater than 0 and lower than 1.");
        }
        this.overUtilizationThreshold = overUtilizationThreshold;
    }

    @Override
    public double getOverUtilizationThreshold(Host host) {
        return this.overUtilizationThreshold;
    }
}

