/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.allocationpolicies;

import java.util.List;
import java.util.Optional;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicy;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicyAbstract;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.vms.Vm;

public class VmAllocationPolicyRoundRobin
extends VmAllocationPolicyAbstract
implements VmAllocationPolicy {
    private int lastHostIndex;

    @Override
    protected Optional<Host> defaultFindHostForVm(Vm vm) {
        List hostList = this.getHostList();
        int maxTries = hostList.size();
        for (int i = 0; i < maxTries; ++i) {
            Host host = (Host)hostList.get(this.lastHostIndex);
            ++this.lastHostIndex;
            this.lastHostIndex %= hostList.size();
            if (!host.isSuitableForVm(vm)) continue;
            return Optional.of(host);
        }
        return Optional.empty();
    }
}

