/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.allocationpolicies;

import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicy;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicyAbstract;
import org.cloudsimplus.distributions.ContinuousDistribution;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.vms.Vm;

public class VmAllocationPolicyRandom
extends VmAllocationPolicyAbstract
implements VmAllocationPolicy {
    private final ContinuousDistribution random;

    public VmAllocationPolicyRandom(@NonNull ContinuousDistribution random) {
        if (random == null) {
            throw new NullPointerException("random is marked non-null but is null");
        }
        this.random = random;
    }

    @Override
    protected Optional<Host> defaultFindHostForVm(Vm vm) {
        List hostList = this.getHostList();
        int maxTries = hostList.size();
        for (int i = 0; i < maxTries; ++i) {
            int hostIndex = (int)(this.random.sample() * (double)hostList.size());
            Host host = (Host)hostList.get(hostIndex);
            if (!host.isSuitableForVm(vm)) continue;
            return Optional.of(host);
        }
        return Optional.empty();
    }
}

