/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.allocationpolicies;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.cloudsimplus.allocationpolicies.VmAllocationPolicy;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.cloudsimplus.datacenters.Datacenter;
import org.cloudsimplus.hosts.Host;
import org.cloudsimplus.hosts.HostSuitability;
import org.cloudsimplus.provisioners.ResourceProvisioner;
import org.cloudsimplus.resources.Processor;
import org.cloudsimplus.resources.ResourceManageable;
import org.cloudsimplus.schedulers.MipsShare;
import org.cloudsimplus.util.Conversion;
import org.cloudsimplus.vms.Vm;
import org.cloudsimplus.vms.VmGroup;

public abstract class VmAllocationPolicyAbstract
implements VmAllocationPolicy {
    private BiFunction<VmAllocationPolicy, Vm, Optional<Host>> findHostForVmFunction;
    @NonNull
    private Datacenter datacenter;
    private int hostCountForParallelSearch;

    public VmAllocationPolicyAbstract() {
        this(null);
    }

    public VmAllocationPolicyAbstract(BiFunction<VmAllocationPolicy, Vm, Optional<Host>> findHostForVmFunction) {
        this.setDatacenter(Datacenter.NULL);
        this.setFindHostForVmFunction(findHostForVmFunction);
        this.hostCountForParallelSearch = 20000;
    }

    @Override
    public final <T extends Host> List<T> getHostList() {
        return this.datacenter.getHostList();
    }

    @Override
    public boolean scaleVmVertically(VerticalVmScaling scaling) {
        if (scaling.isVmUnderloaded()) {
            return this.downScaleVmVertically(scaling);
        }
        if (scaling.isVmOverloaded()) {
            return this.upScaleVmVertically(scaling);
        }
        return false;
    }

    private boolean upScaleVmVertically(VerticalVmScaling scaling) {
        return this.isRequestingCpuScaling(scaling) ? this.scaleVmPesUpOrDown(scaling) : this.upScaleVmNonCpuResource(scaling);
    }

    private boolean downScaleVmVertically(VerticalVmScaling scaling) {
        return this.isRequestingCpuScaling(scaling) ? this.scaleVmPesUpOrDown(scaling) : this.downScaleVmNonCpuResource(scaling);
    }

    private boolean scaleVmPesUpOrDown(VerticalVmScaling scaling) {
        double pesNumberForScaling = scaling.getResourceAmountToScale();
        if (pesNumberForScaling == 0.0) {
            return false;
        }
        boolean isVmUnderloaded = scaling.isVmUnderloaded();
        if (isVmUnderloaded && (double)scaling.getVm().getPesNumber() == pesNumberForScaling) {
            scaling.logDownscaleToZeroNotAllowed();
            return false;
        }
        if (scaling.isVmOverloaded() && this.isNotHostPesSuitableToUpScaleVm(scaling)) {
            scaling.logResourceUnavailable();
            return false;
        }
        Vm vm = scaling.getVm();
        vm.getHost().getVmScheduler().deallocatePesFromVm(vm);
        int signal = isVmUnderloaded ? -1 : 1;
        vm.getProcessor().sumCapacity((long)pesNumberForScaling * (long)signal);
        vm.getHost().getVmScheduler().allocatePesForVm(vm);
        return true;
    }

    private boolean isNotHostPesSuitableToUpScaleVm(VerticalVmScaling scaling) {
        Vm vm = scaling.getVm();
        long pesCountForScaling = (long)scaling.getResourceAmountToScale();
        MipsShare additionalVmMips = new MipsShare(pesCountForScaling, vm.getMips());
        return !vm.getHost().getVmScheduler().isSuitableForVm(vm, additionalVmMips);
    }

    private boolean isRequestingCpuScaling(VerticalVmScaling scaling) {
        return Processor.class.equals(scaling.getResourceClass());
    }

    private boolean upScaleVmNonCpuResource(VerticalVmScaling scaling) {
        return scaling.allocateResourceForVm();
    }

    private boolean downScaleVmNonCpuResource(VerticalVmScaling scaling) {
        Class<? extends ResourceManageable> resourceManageableClass = scaling.getResourceClass();
        ResourceManageable vmResource = scaling.getVm().getResource(resourceManageableClass);
        double amountToDeallocate = scaling.getResourceAmountToScale();
        ResourceProvisioner resourceProvisioner = scaling.getVm().getHost().getProvisioner(resourceManageableClass);
        double newTotalVmResource = (double)vmResource.getCapacity() - amountToDeallocate;
        if (resourceProvisioner.allocateResourceForVm(scaling.getVm(), newTotalVmResource)) {
            LOGGER.info("{}: {}: {} {} deallocated from {}: new capacity is {}. Current resource usage is {}%", new Object[]{scaling.getVm().getSimulation().clockStr(), scaling.getClass().getSimpleName(), (long)amountToDeallocate, resourceManageableClass.getSimpleName(), scaling.getVm(), vmResource.getCapacity(), vmResource.getPercentUtilization() * 100.0});
            return true;
        }
        LOGGER.error("{}: {}: {} requested to reduce {} capacity by {} but an unexpected error occurred and the resource was not resized", new Object[]{scaling.getVm().getSimulation().clockStr(), scaling.getClass().getSimpleName(), scaling.getVm(), resourceManageableClass.getSimpleName(), (long)amountToDeallocate});
        return false;
    }

    @Override
    public HostSuitability allocateHostForVm(Vm vm) {
        if (this.getHostList().isEmpty()) {
            LOGGER.error("{}: {}: {} could not be allocated because there isn't any Host for Datacenter {}", new Object[]{vm.getSimulation().clockStr(), this.getClass().getSimpleName(), vm, this.getDatacenter().getId()});
            return new HostSuitability("Datacenter has no host.");
        }
        if (vm.isCreated()) {
            return new HostSuitability("VM is already created");
        }
        Optional<Host> optionalHost = this.findHostForVm(vm);
        if (optionalHost.filter(Host::isActive).isPresent()) {
            return this.allocateHostForVm(vm, optionalHost.get());
        }
        LOGGER.warn("{}: {}: No suitable host found for {} in {}", new Object[]{vm.getSimulation().clockStr(), this.getClass().getSimpleName(), vm, this.datacenter});
        return new HostSuitability("No suitable host found");
    }

    @Override
    public <T extends Vm> List<T> allocateHostForVm(@NonNull Collection<T> vmCollection) {
        if (vmCollection == null) {
            throw new NullPointerException("vmCollection is marked non-null but is null");
        }
        return vmCollection.stream().filter(vm -> !this.allocateHostForVm((Vm)vm).fully()).collect(Collectors.toList());
    }

    @Override
    public HostSuitability allocateHostForVm(Vm vm, Host host) {
        if (vm instanceof VmGroup) {
            VmGroup vmGroup = (VmGroup)vm;
            return this.createVmsFromGroup(vmGroup, host);
        }
        return this.createVm(vm, host);
    }

    private HostSuitability createVmsFromGroup(VmGroup vmGroup, Host host) {
        int createdVms = 0;
        HostSuitability hostSuitabilityForVmGroup = new HostSuitability();
        for (Vm vm : vmGroup.getVmList()) {
            HostSuitability hostSuitability = this.createVm(vm, host);
            hostSuitabilityForVmGroup.setSuitability(hostSuitability);
            createdVms += Conversion.boolToInt(hostSuitability.fully());
        }
        vmGroup.setCreated(createdVms > 0);
        if (vmGroup.isCreated()) {
            vmGroup.setHost(host);
        }
        return hostSuitabilityForVmGroup;
    }

    private HostSuitability createVm(Vm vm, Host host) {
        HostSuitability suitability = host.createVm(vm);
        if (suitability.fully()) {
            LOGGER.info("{}: {}: {} has been allocated to {}", new Object[]{vm.getSimulation().clockStr(), this.getClass().getSimpleName(), vm, host});
        } else {
            LOGGER.error("{}: {} Creation of {} on {} failed due to {}.", new Object[]{vm.getSimulation().clockStr(), this.getClass().getSimpleName(), vm, host, suitability});
        }
        return suitability;
    }

    @Override
    public void deallocateHostForVm(Vm vm) {
        vm.getHost().destroyVm(vm);
    }

    @Override
    public final VmAllocationPolicy setFindHostForVmFunction(BiFunction<VmAllocationPolicy, Vm, Optional<Host>> findHostForVmFunction) {
        this.findHostForVmFunction = findHostForVmFunction;
        return this;
    }

    @Override
    public final Optional<Host> findHostForVm(Vm vm) {
        Optional<Host> optionalHost = this.findHostForVmFunction == null ? this.defaultFindHostForVm(vm) : this.findHostForVmFunction.apply(this, vm);
        return optionalHost.map(host -> host.setActive(true));
    }

    protected abstract Optional<Host> defaultFindHostForVm(Vm var1);

    @Override
    public Map<Vm, Host> getOptimizedAllocationMap(List<? extends Vm> vmList) {
        return Collections.emptyMap();
    }

    @Override
    public boolean isVmMigrationSupported() {
        return false;
    }

    public BiFunction<VmAllocationPolicy, Vm, Optional<Host>> getFindHostForVmFunction() {
        return this.findHostForVmFunction;
    }

    @Override
    @NonNull
    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    @Override
    public int getHostCountForParallelSearch() {
        return this.hostCountForParallelSearch;
    }

    @Override
    public VmAllocationPolicyAbstract setDatacenter(@NonNull Datacenter datacenter) {
        if (datacenter == null) {
            throw new NullPointerException("datacenter is marked non-null but is null");
        }
        this.datacenter = datacenter;
        return this;
    }

    @Override
    public VmAllocationPolicyAbstract setHostCountForParallelSearch(int hostCountForParallelSearch) {
        this.hostCountForParallelSearch = hostCountForParallelSearch;
        return this;
    }
}

