/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.router.jakarta;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;

final class ClientCertificateMapper
implements Filter {
    static final String ATTRIBUTE = "jakarta.servlet.request.X509Certificate";
    static final String HEADER = "X-Forwarded-Client-Cert";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");

    ClientCertificateMapper() throws CertificateException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            try {
                List<X509Certificate> certificates = this.getCertificates((HttpServletRequest)request);
                if (!certificates.isEmpty()) {
                    request.setAttribute(ATTRIBUTE, (Object)certificates.toArray(new X509Certificate[0]));
                }
            }
            catch (CertificateException e) {
                this.logger.warning("Unable to parse certificates in X-Forwarded-Client-Cert");
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) {
    }

    private byte[] decodeHeader(String rawCertificate) {
        try {
            return Base64.getDecoder().decode(rawCertificate);
        }
        catch (IllegalArgumentException e1) {
            try {
                return URLDecoder.decode(rawCertificate, "utf-8").getBytes();
            }
            catch (UnsupportedEncodingException e2) {
                throw new IllegalArgumentException("Header contains value that is neither base64 nor url encoded");
            }
        }
    }

    private List<X509Certificate> getCertificates(HttpServletRequest request) throws CertificateException, IOException {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (String rawCertificate : this.getRawCertificates(request)) {
            try (ByteArrayInputStream in = new ByteArrayInputStream(this.decodeHeader(rawCertificate));){
                certificates.add((X509Certificate)this.certificateFactory.generateCertificate(in));
            }
        }
        return certificates;
    }

    private List<String> getRawCertificates(HttpServletRequest request) {
        Enumeration candidates = request.getHeaders(HEADER);
        if (candidates == null) {
            return Collections.emptyList();
        }
        ArrayList<String> rawCertificates = new ArrayList<String>();
        while (candidates.hasMoreElements()) {
            String candidate = (String)candidates.nextElement();
            if (this.hasMultipleCertificates(candidate)) {
                rawCertificates.addAll(Arrays.asList(candidate.split(",")));
                continue;
            }
            rawCertificates.add(candidate);
        }
        return rawCertificates;
    }

    private boolean hasMultipleCertificates(String candidate) {
        return candidate.indexOf(44) != -1;
    }
}

