/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.resourcematch.ListMatchingResourcesRequest;
import org.cloudfoundry.client.v2.resourcematch.ListMatchingResourcesResponse;
import org.cloudfoundry.client.v2.resourcematch.Resource;
import org.cloudfoundry.util.FileUtils;
import org.cloudfoundry.util.SizeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class ResourceMatchingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"cloudfoundry-client.resource-matching");

    private ResourceMatchingUtils() {
    }

    public static Mono<List<ArtifactMetadata>> getMatchedResources(CloudFoundryClient cloudFoundryClient, Path application) {
        return (Files.isDirectory(application, new LinkOption[0]) ? ResourceMatchingUtils.getArtifactMetadataFromDirectory(application) : ResourceMatchingUtils.getArtifactMetadataFromZip(application)).collectMap(ArtifactMetadata::getHash).flatMapMany(artifactMetadatas -> ResourceMatchingUtils.requestListMatchingResources(cloudFoundryClient, artifactMetadatas.values()).flatMapIterable(ListMatchingResourcesResponse::getResources).map(resource -> (ArtifactMetadata)artifactMetadatas.get(resource.getHash()))).collectList().doOnNext(matched -> LOGGER.debug("{} resources matched totaling {}", (Object)matched.size(), (Object)SizeUtils.asIbi(matched.stream().mapToInt(ArtifactMetadata::getSize).sum()))).subscribeOn(Schedulers.boundedElastic());
    }

    private static Flux<ArtifactMetadata> getArtifactMetadataFromDirectory(Path application) {
        return Flux.defer(() -> {
            try {
                return Flux.fromStream(Files.walk(application, new FileVisitOption[0]));
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }).filter(path -> !Files.isDirectory(path, new LinkOption[0])).map(path -> new ArtifactMetadata(FileUtils.hash(path), FileUtils.getRelativePathName(application, path), FileUtils.permissions(path), FileUtils.size(path)));
    }

    private static Flux<ArtifactMetadata> getArtifactMetadataFromZip(Path application) {
        ArrayList<ArtifactMetadata> artifactMetadatas = new ArrayList<ArtifactMetadata>();
        try (ZipFile zipFile = new ZipFile(application.toFile());){
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                if (entry.isDirectory()) continue;
                InputStream in = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    String hash = FileUtils.hash(in);
                    String path = entry.getName();
                    String permissions = FileUtils.permissions(entry.getUnixMode());
                    int size = (int)entry.getSize();
                    artifactMetadatas.add(new ArtifactMetadata(hash, path, permissions, size));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        return Flux.fromIterable(artifactMetadatas);
    }

    private static Mono<ListMatchingResourcesResponse> requestListMatchingResources(CloudFoundryClient cloudFoundryClient, Collection<ArtifactMetadata> artifactMetadatas) {
        ListMatchingResourcesRequest request = artifactMetadatas.stream().reduce(ListMatchingResourcesRequest.builder(), (builder, artifactMetadata) -> builder.resource(Resource.builder().hash(artifactMetadata.getHash()).mode(artifactMetadata.getPermissions()).size(Integer.valueOf(artifactMetadata.getSize())).build()), (a, b) -> a.addAllResources((Iterable)b.build().getResources())).build();
        return cloudFoundryClient.resourceMatch().list(request);
    }

    public static final class ArtifactMetadata {
        private final String hash;
        private final String path;
        private final String permissions;
        private final int size;

        public ArtifactMetadata(String hash, String path, String permissions, int size) {
            this.hash = hash;
            this.path = path;
            this.permissions = permissions;
            this.size = size;
        }

        public String getHash() {
            return this.hash;
        }

        public String getPath() {
            return this.path;
        }

        public String getPermissions() {
            return this.permissions;
        }

        public int getSize() {
            return this.size;
        }
    }
}

