/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.util;

import java.time.Duration;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.ClientV2Exception;
import org.cloudfoundry.client.v2.Resource;
import org.cloudfoundry.client.v2.jobs.ErrorDetails;
import org.cloudfoundry.client.v2.jobs.GetJobResponse;
import org.cloudfoundry.client.v2.jobs.JobEntity;
import org.cloudfoundry.client.v3.ClientV3Exception;
import org.cloudfoundry.client.v3.jobs.GetJobRequest;
import org.cloudfoundry.client.v3.jobs.Job;
import org.cloudfoundry.client.v3.jobs.JobState;
import org.cloudfoundry.util.DelayUtils;
import org.cloudfoundry.util.ResourceUtils;
import reactor.core.publisher.Mono;

public final class JobUtils {
    private static final Set<JobState> FINAL_STATES = EnumSet.of(JobState.COMPLETE, JobState.FAILED);
    private static final Integer STATUS_OK = 200;

    private JobUtils() {
    }

    public static <R extends Resource<JobEntity>> Mono<Void> waitForCompletion(CloudFoundryClient cloudFoundryClient, Duration completionTimeout, R resource) {
        return JobUtils.waitForCompletion(cloudFoundryClient, completionTimeout, (JobEntity)ResourceUtils.getEntity(resource));
    }

    public static Mono<Void> waitForCompletion(CloudFoundryClient cloudFoundryClient, Duration completionTimeout, JobEntity jobEntity) {
        Mono job = JobUtils.isComplete(jobEntity) ? Mono.just((Object)jobEntity) : JobUtils.requestJobV2(cloudFoundryClient, jobEntity.getId()).map(GetJobResponse::getEntity).filter(JobUtils::isComplete).repeatWhenEmpty(DelayUtils.exponentialBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(15L), completionTimeout));
        return job.filter(entity -> "failed".equals(entity.getStatus())).flatMap(JobUtils::getError);
    }

    public static Mono<Void> waitForCompletion(CloudFoundryClient cloudFoundryClient, Duration completionTimeout, String jobId) {
        return JobUtils.requestJobV3(cloudFoundryClient, jobId).filter(job -> FINAL_STATES.contains(job.getState())).repeatWhenEmpty(DelayUtils.exponentialBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(15L), completionTimeout)).filter(job -> JobState.FAILED == job.getState()).flatMap(JobUtils::getError);
    }

    private static Mono<Void> getError(JobEntity entity) {
        ErrorDetails errorDetails = entity.getErrorDetails();
        return Mono.error((Throwable)new ClientV2Exception(null, errorDetails.getCode(), errorDetails.getDescription(), errorDetails.getErrorCode()));
    }

    private static Mono<Void> getError(Job job) {
        List errors = job.getErrors();
        return Mono.error((Throwable)new ClientV3Exception(STATUS_OK, errors));
    }

    private static boolean isComplete(JobEntity entity) {
        String status = entity.getStatus();
        return "finished".equals(status) || "failed".equals(status);
    }

    private static Mono<GetJobResponse> requestJobV2(CloudFoundryClient cloudFoundryClient, String jobId) {
        return cloudFoundryClient.jobs().get(org.cloudfoundry.client.v2.jobs.GetJobRequest.builder().jobId(jobId).build());
    }

    private static Mono<org.cloudfoundry.client.v3.jobs.GetJobResponse> requestJobV3(CloudFoundryClient cloudFoundryClient, String jobId) {
        return cloudFoundryClient.jobsV3().get(GetJobRequest.builder().jobId(jobId).build());
    }
}

