/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.spaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.operations.spaceadmin.SpaceQuota;
import org.cloudfoundry.operations.spaces.SecurityGroup;
import org.cloudfoundry.operations.spaces._SpaceDetail;
import org.immutables.value.Generated;

@Generated(from="_SpaceDetail", generator="Immutables")
public final class SpaceDetail
extends _SpaceDetail {
    private final List<String> applications;
    private final List<String> domains;
    private final String id;
    private final String name;
    private final String organization;
    private final List<SecurityGroup> securityGroups;
    private final List<String> services;
    private final SpaceQuota spaceQuota;

    private SpaceDetail(Builder builder) {
        this.applications = SpaceDetail.createUnmodifiableList(true, builder.applications);
        this.domains = SpaceDetail.createUnmodifiableList(true, builder.domains);
        this.id = builder.id;
        this.name = builder.name;
        this.organization = builder.organization;
        this.securityGroups = SpaceDetail.createUnmodifiableList(true, builder.securityGroups);
        this.services = SpaceDetail.createUnmodifiableList(true, builder.services);
        this.spaceQuota = builder.spaceQuota;
    }

    @Override
    public List<String> getApplications() {
        return this.applications;
    }

    @Override
    public List<String> getDomains() {
        return this.domains;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOrganization() {
        return this.organization;
    }

    @Override
    public List<SecurityGroup> getSecurityGroups() {
        return this.securityGroups;
    }

    @Override
    public List<String> getServices() {
        return this.services;
    }

    @Override
    public Optional<SpaceQuota> getSpaceQuota() {
        return Optional.ofNullable(this.spaceQuota);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SpaceDetail && this.equalTo(0, (SpaceDetail)another);
    }

    private boolean equalTo(int synthetic, SpaceDetail another) {
        return this.applications.equals(another.applications) && this.domains.equals(another.domains) && this.id.equals(another.id) && this.name.equals(another.name) && this.organization.equals(another.organization) && this.securityGroups.equals(another.securityGroups) && this.services.equals(another.services) && Objects.equals(this.spaceQuota, another.spaceQuota);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applications.hashCode();
        h += (h << 5) + this.domains.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.organization.hashCode();
        h += (h << 5) + this.securityGroups.hashCode();
        h += (h << 5) + this.services.hashCode();
        h += (h << 5) + Objects.hashCode(this.spaceQuota);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SpaceDetail{");
        builder.append("applications=").append(this.applications);
        builder.append(", ");
        builder.append("domains=").append(this.domains);
        builder.append(", ");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("organization=").append(this.organization);
        builder.append(", ");
        builder.append("securityGroups=").append(this.securityGroups);
        builder.append(", ");
        builder.append("services=").append(this.services);
        if (this.spaceQuota != null) {
            builder.append(", ");
            builder.append("spaceQuota=").append(this.spaceQuota);
        }
        return builder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_SpaceDetail", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_ORGANIZATION = 4L;
        private long initBits = 7L;
        private List<String> applications = new ArrayList<String>();
        private List<String> domains = new ArrayList<String>();
        private String id;
        private String name;
        private String organization;
        private List<SecurityGroup> securityGroups = new ArrayList<SecurityGroup>();
        private List<String> services = new ArrayList<String>();
        private SpaceQuota spaceQuota;

        private Builder() {
        }

        public final Builder from(SpaceDetail instance) {
            return this.from((_SpaceDetail)instance);
        }

        final Builder from(_SpaceDetail instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllApplications(instance.getApplications());
            this.addAllDomains(instance.getDomains());
            this.id(instance.getId());
            this.name(instance.getName());
            this.organization(instance.getOrganization());
            this.addAllSecurityGroups(instance.getSecurityGroups());
            this.addAllServices(instance.getServices());
            Optional<SpaceQuota> spaceQuotaOptional = instance.getSpaceQuota();
            if (spaceQuotaOptional.isPresent()) {
                this.spaceQuota(spaceQuotaOptional);
            }
            return this;
        }

        public final Builder application(String element) {
            this.applications.add(Objects.requireNonNull(element, "applications element"));
            return this;
        }

        public final Builder applications(String ... elements) {
            for (String element : elements) {
                this.applications.add(Objects.requireNonNull(element, "applications element"));
            }
            return this;
        }

        public final Builder applications(Iterable<String> elements) {
            this.applications.clear();
            return this.addAllApplications(elements);
        }

        public final Builder addAllApplications(Iterable<String> elements) {
            for (String element : elements) {
                this.applications.add(Objects.requireNonNull(element, "applications element"));
            }
            return this;
        }

        public final Builder domain(String element) {
            this.domains.add(Objects.requireNonNull(element, "domains element"));
            return this;
        }

        public final Builder domains(String ... elements) {
            for (String element : elements) {
                this.domains.add(Objects.requireNonNull(element, "domains element"));
            }
            return this;
        }

        public final Builder domains(Iterable<String> elements) {
            this.domains.clear();
            return this.addAllDomains(elements);
        }

        public final Builder addAllDomains(Iterable<String> elements) {
            for (String element : elements) {
                this.domains.add(Objects.requireNonNull(element, "domains element"));
            }
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder organization(String organization) {
            this.organization = Objects.requireNonNull(organization, "organization");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder securityGroup(SecurityGroup element) {
            this.securityGroups.add(Objects.requireNonNull(element, "securityGroups element"));
            return this;
        }

        public final Builder securityGroups(SecurityGroup ... elements) {
            for (SecurityGroup element : elements) {
                this.securityGroups.add(Objects.requireNonNull(element, "securityGroups element"));
            }
            return this;
        }

        public final Builder securityGroups(Iterable<? extends SecurityGroup> elements) {
            this.securityGroups.clear();
            return this.addAllSecurityGroups(elements);
        }

        public final Builder addAllSecurityGroups(Iterable<? extends SecurityGroup> elements) {
            for (SecurityGroup securityGroup : elements) {
                this.securityGroups.add(Objects.requireNonNull(securityGroup, "securityGroups element"));
            }
            return this;
        }

        public final Builder service(String element) {
            this.services.add(Objects.requireNonNull(element, "services element"));
            return this;
        }

        public final Builder services(String ... elements) {
            for (String element : elements) {
                this.services.add(Objects.requireNonNull(element, "services element"));
            }
            return this;
        }

        public final Builder services(Iterable<String> elements) {
            this.services.clear();
            return this.addAllServices(elements);
        }

        public final Builder addAllServices(Iterable<String> elements) {
            for (String element : elements) {
                this.services.add(Objects.requireNonNull(element, "services element"));
            }
            return this;
        }

        public final Builder spaceQuota(SpaceQuota spaceQuota) {
            this.spaceQuota = Objects.requireNonNull(spaceQuota, "spaceQuota");
            return this;
        }

        public final Builder spaceQuota(Optional<? extends SpaceQuota> spaceQuota) {
            this.spaceQuota = spaceQuota.orElse(null);
            return this;
        }

        public SpaceDetail build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new SpaceDetail(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("organization");
            }
            return "Cannot build SpaceDetail, some of required attributes are not set " + attributes;
        }
    }
}

