/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.routes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.routes._Route;
import org.immutables.value.Generated;

@Generated(from="_Route", generator="Immutables")
public final class Route
extends _Route {
    private final List<String> applications;
    private final String domain;
    private final String host;
    private final String id;
    @Nullable
    private final String path;
    @Nullable
    private final String port;
    @Nullable
    private final String service;
    private final String space;
    @Nullable
    private final String type;

    private Route(Builder builder) {
        this.applications = Route.createUnmodifiableList(true, builder.applications);
        this.domain = builder.domain;
        this.host = builder.host;
        this.id = builder.id;
        this.path = builder.path;
        this.port = builder.port;
        this.service = builder.service;
        this.space = builder.space;
        this.type = builder.type;
    }

    @Override
    public List<String> getApplications() {
        return this.applications;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public String getPort() {
        return this.port;
    }

    @Override
    @Nullable
    public String getService() {
        return this.service;
    }

    @Override
    public String getSpace() {
        return this.space;
    }

    @Override
    @Nullable
    public String getType() {
        return this.type;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Route && this.equalTo(0, (Route)another);
    }

    private boolean equalTo(int synthetic, Route another) {
        return this.applications.equals(another.applications) && this.domain.equals(another.domain) && this.host.equals(another.host) && this.id.equals(another.id) && Objects.equals(this.path, another.path) && Objects.equals(this.port, another.port) && Objects.equals(this.service, another.service) && this.space.equals(another.space) && Objects.equals(this.type, another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applications.hashCode();
        h += (h << 5) + this.domain.hashCode();
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + Objects.hashCode(this.service);
        h += (h << 5) + this.space.hashCode();
        h += (h << 5) + Objects.hashCode(this.type);
        return h;
    }

    public String toString() {
        return "Route{applications=" + this.applications + ", domain=" + this.domain + ", host=" + this.host + ", id=" + this.id + ", path=" + this.path + ", port=" + this.port + ", service=" + this.service + ", space=" + this.space + ", type=" + this.type + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_Route", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DOMAIN = 1L;
        private static final long INIT_BIT_HOST = 2L;
        private static final long INIT_BIT_ID = 4L;
        private static final long INIT_BIT_SPACE = 8L;
        private long initBits = 15L;
        private List<String> applications = new ArrayList<String>();
        private String domain;
        private String host;
        private String id;
        private String path;
        private String port;
        private String service;
        private String space;
        private String type;

        private Builder() {
        }

        public final Builder from(Route instance) {
            return this.from((_Route)instance);
        }

        final Builder from(_Route instance) {
            String serviceValue;
            String portValue;
            Objects.requireNonNull(instance, "instance");
            this.addAllApplications(instance.getApplications());
            this.domain(instance.getDomain());
            this.host(instance.getHost());
            this.id(instance.getId());
            String pathValue = instance.getPath();
            if (pathValue != null) {
                this.path(pathValue);
            }
            if ((portValue = instance.getPort()) != null) {
                this.port(portValue);
            }
            if ((serviceValue = instance.getService()) != null) {
                this.service(serviceValue);
            }
            this.space(instance.getSpace());
            String typeValue = instance.getType();
            if (typeValue != null) {
                this.type(typeValue);
            }
            return this;
        }

        public final Builder application(String element) {
            this.applications.add(Objects.requireNonNull(element, "applications element"));
            return this;
        }

        public final Builder applications(String ... elements) {
            for (String element : elements) {
                this.applications.add(Objects.requireNonNull(element, "applications element"));
            }
            return this;
        }

        public final Builder applications(Iterable<String> elements) {
            this.applications.clear();
            return this.addAllApplications(elements);
        }

        public final Builder addAllApplications(Iterable<String> elements) {
            for (String element : elements) {
                this.applications.add(Objects.requireNonNull(element, "applications element"));
            }
            return this;
        }

        public final Builder domain(String domain) {
            this.domain = Objects.requireNonNull(domain, "domain");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        public final Builder port(@Nullable String port) {
            this.port = port;
            return this;
        }

        public final Builder service(@Nullable String service) {
            this.service = service;
            return this;
        }

        public final Builder space(String space) {
            this.space = Objects.requireNonNull(space, "space");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public Route build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Route(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("domain");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("space");
            }
            return "Cannot build Route, some of required attributes are not set " + attributes;
        }
    }
}

