package org.cloudfoundry.operations.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request options for the check space ssh enabled operation
 */
@Generated(from = "_SpaceSshAllowedRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class SpaceSshAllowedRequest extends org.cloudfoundry.operations.spaces._SpaceSshAllowedRequest {
  private final String name;

  private SpaceSshAllowedRequest(SpaceSshAllowedRequest.Builder builder) {
    this.name = builder.name;
  }

  /**
   * The space name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code SpaceSshAllowedRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SpaceSshAllowedRequest
        && equalTo(0, (SpaceSshAllowedRequest) another);
  }

  private boolean equalTo(int synthetic, SpaceSshAllowedRequest another) {
    return name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SpaceSshAllowedRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SpaceSshAllowedRequest{"
        + "name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link SpaceSshAllowedRequest SpaceSshAllowedRequest}.
   * <pre>
   * SpaceSshAllowedRequest.builder()
   *    .name(String) // required {@link SpaceSshAllowedRequest#getName() name}
   *    .build();
   * </pre>
   * @return A new SpaceSshAllowedRequest builder
   */
  public static SpaceSshAllowedRequest.Builder builder() {
    return new SpaceSshAllowedRequest.Builder();
  }

  /**
   * Builds instances of type {@link SpaceSshAllowedRequest SpaceSshAllowedRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_SpaceSshAllowedRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SpaceSshAllowedRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SpaceSshAllowedRequest instance) {
      return from((_SpaceSshAllowedRequest) instance);
    }

    /**
     * Copy abstract value type {@code _SpaceSshAllowedRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SpaceSshAllowedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceSshAllowedRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link SpaceSshAllowedRequest SpaceSshAllowedRequest}.
     * @return An immutable instance of SpaceSshAllowedRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SpaceSshAllowedRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new SpaceSshAllowedRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build SpaceSshAllowedRequest, some of required attributes are not set " + attributes;
    }
  }
}
